require('game/creatures/Animal');
require('game/managers/Creature');
require('engine/core/MVCommons');

Creatures.Sheep = MVC.deepClone(Creatures.Animal);

(function($){
  $.creatureName = 'sheep';
  $.creatureKindName = 'sheep';
  $.creatureKindEnabled = false;

  $._spriteName = 'animals/sheep';
  $._spriteIndex = 0;

  $._hitboxX = 8;
  $._hitboxY = 8;
  $._hitboxWidth = 24;
  $._hitboxHeight = 24;

  $._offsetX = 0;
  $._offsetY = 0;
  $._price = 3000;
  $.isSheep = true;

  $.processCreatureNewDay = function(creature) {
    if (creature.mapId === Maps.ANIMAL_CAMP) {
      creature.upsetLevel -= 1;
      this.reduceStress(creature);
      return;
    }

    creature.sheared = false;

    if (!BarnMap.consumeAnimalFoodInMap(creature.mapId)) {
      if (!Managers.Map.mapIsFarm(creature.mapId)) {
        creature.upsetLevel += 1;
        return;
      }

      if (Managers.Weather.isBadWeather() || Managers.Weather.wasBadWeather()) {
        creature.upsetLevel += 2;
        return;
      }

      creature.upsetLevel -= 0.5;
    }

    if (creature.woolDays === undefined) {
      creature.woolDays = 0;
    }

    if (creature.upsetLevel <= 0) {
      creature.woolDays++;

      if (creature.woolDays >= 7) {
        creature.hasWool = true;
      }
    }

    this.reduceStress(creature);
    if (creature.upsetLevel > 10) {
      creature.upsetLevel = 10;
    }
  };

  $.getWoolItemId = function(creature) {
    return 'wool';
  };
})(Creatures.Sheep);

Creatures.Sheep2 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep3 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep4 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep5 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep6 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep7 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep8 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep9 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep10 = MVC.deepClone(Creatures.Sheep);
Creatures.Sheep11 = MVC.deepClone(Creatures.Sheep);

Creatures.Sheep2.creatureName = 'sheep2';
Creatures.Sheep2._spriteIndex = 1;

Creatures.Sheep3.creatureName = 'sheep3';
Creatures.Sheep3._spriteIndex = 2;

Creatures.Sheep4.creatureName = 'sheep4';
Creatures.Sheep4._spriteIndex = 3;
Creatures.Sheep4.getWoolItemId = (creature) => {
  return 'black-wool';
};

Creatures.Sheep5.creatureName = 'sheep5';
Creatures.Sheep5._spriteIndex = 4;
Creatures.Sheep5.getWoolItemId = (creature) => {
  return 'black-wool';
};

Creatures.Sheep6.creatureName = 'sheep6';
Creatures.Sheep6._spriteIndex = 5;
Creatures.Sheep6.getWoolItemId = (creature) => {
  return 'yellow-wool';
};

Creatures.Sheep7.creatureName = 'sheep7';
Creatures.Sheep7._spriteIndex = 6;
Creatures.Sheep7.getWoolItemId = (creature) => {
  return 'yellow-wool';
};

Creatures.Sheep8.creatureName = 'sheep8';
Creatures.Sheep8._spriteIndex = 7;

Creatures.Sheep9.creatureName = 'sheep9';
Creatures.Sheep9._spriteName = 'animals/color-sheep';
Creatures.Sheep9._spriteIndex = 0;
Creatures.Sheep9.getWoolItemId = (creature) => {
  return 'blue-wool';
};

Creatures.Sheep10.creatureName = 'sheep10';
Creatures.Sheep10._spriteName = 'animals/color-sheep';
Creatures.Sheep10._spriteIndex = 1;
Creatures.Sheep10.getWoolItemId = (creature) => {
  return 'green-wool';
};

Creatures.Sheep11.creatureName = 'sheep11';
Creatures.Sheep11._spriteName = 'animals/color-sheep';
Creatures.Sheep11._spriteIndex = 2;
Creatures.Sheep11.getWoolItemId = (creature) => {
  return 'red-wool';
};

Managers.Creatures.registerCreature(Creatures.Sheep);
Managers.Creatures.registerCreature(Creatures.Sheep2);
Managers.Creatures.registerCreature(Creatures.Sheep3);
Managers.Creatures.registerCreature(Creatures.Sheep4);
Managers.Creatures.registerCreature(Creatures.Sheep5);
Managers.Creatures.registerCreature(Creatures.Sheep6);
Managers.Creatures.registerCreature(Creatures.Sheep7);
Managers.Creatures.registerCreature(Creatures.Sheep8);
Managers.Creatures.registerCreature(Creatures.Sheep9);
Managers.Creatures.registerCreature(Creatures.Sheep10);
Managers.Creatures.registerCreature(Creatures.Sheep11);