require('game/creatures/Animal');
require('game/managers/Creature');
require('engine/core/MVCommons');

Creatures.Rooster = MVC.deepClone(Creatures.Animal);

(function($){
  $.creatureName = 'rooster';
  $.creatureKindName = 'rooster';
  $.creatureKindEnabled = true;

  $._spriteName = 'animals/rooster';
  $._spriteIndex = 0;

  // $._hitboxX = 17;
  // $._hitboxY = 34;
  // $._hitboxWidth = 30;
  // $._hitboxHeight = 30;
  $._offsetX = 0;
  $._offsetY = -10;

  $.isRooster = true;
  $._onePerMap = true;

  $.processCreatureNewDay = function(creature) {

  };

  $.processLateNewDay = function(creature) {
    if (creature.mapId === Maps.ANIMAL_CAMP) {
      return;
    }

    const coopMap = Managers.Map.getClass(Maps.COOP);

    if (!coopMap.consumeAnimalFoodInMap(creature.mapId)) {
      if (!Managers.Map.mapIsFarm(creature.mapId)) {
        creature.friendship -= 10;
        return;
      }

      if (Managers.Weather.isBadWeather() || Managers.Weather.wasBadWeather()) {
        creature.friendship -= 10;
        return;
      }

      creature.friendship += 2;
    }

    creature.friendship += 1;

    for (var eventId = 1; eventId <= 14; eventId++) {
      var key = [creature.mapId, eventId];

      var a = $gameSelfSwitches.value(key.concat(['A']));
      var b = $gameSelfSwitches.value(key.concat(['B']));
      var c = $gameSelfSwitches.value(key.concat(['C']));

      // If there's only one egg in the nest and it's not been fertilized
      if (!!a && !b && !c) {
        // 10% chance of fertilizing it
        if (Math.randomInt(100) < 10) {
          $gameSelfSwitches.setValue(key.concat(['A']), false);
          $gameSelfSwitches.setValue(key.concat(['B']), false);
          $gameSelfSwitches.setValue(key.concat(['C']), true);
        }
      }
    }
  };
})(Creatures.Rooster);

Creatures.Rooster2 = MVC.deepClone(Creatures.Rooster);
Creatures.Rooster3 = MVC.deepClone(Creatures.Rooster);
Creatures.Rooster4 = MVC.deepClone(Creatures.Rooster);
Creatures.Rooster5 = MVC.deepClone(Creatures.Rooster);
Creatures.Rooster6 = MVC.deepClone(Creatures.Rooster);
Creatures.Rooster7 = MVC.deepClone(Creatures.Rooster);
Creatures.Rooster8 = MVC.deepClone(Creatures.Rooster);

Creatures.Rooster2.creatureName = 'rooster2';
Creatures.Rooster2._spriteIndex = 1;

Creatures.Rooster3.creatureName = 'rooster3';
Creatures.Rooster3._spriteIndex = 2;

Creatures.Rooster4.creatureName = 'rooster4';
Creatures.Rooster4._spriteIndex = 3;

Creatures.Rooster5.creatureName = 'rooster5';
Creatures.Rooster5._spriteIndex = 4;

Creatures.Rooster6.creatureName = 'rooster6';
Creatures.Rooster6._spriteIndex = 5;

Creatures.Rooster7.creatureName = 'rooster7';
Creatures.Rooster7._spriteIndex = 6;

Creatures.Rooster8.creatureName = 'rooster8';
Creatures.Rooster8._spriteIndex = 7;

Managers.Creatures.registerCreature(Creatures.Rooster);
Managers.Creatures.registerCreature(Creatures.Rooster2);
Managers.Creatures.registerCreature(Creatures.Rooster3);
Managers.Creatures.registerCreature(Creatures.Rooster4);
Managers.Creatures.registerCreature(Creatures.Rooster5);
Managers.Creatures.registerCreature(Creatures.Rooster6);
Managers.Creatures.registerCreature(Creatures.Rooster7);
Managers.Creatures.registerCreature(Creatures.Rooster8);