require('game/creatures/Animal');
require('game/managers/Creature');
require('engine/core/MVCommons');

Creatures.Horse = MVC.deepClone(Creatures.Animal);

(function($){
  $.creatureName = 'horse';
  $.creatureKindName = 'horse';
  $.creatureKindEnabled = true;

  $._spriteName = 'animals/horses[4]';
  $._runningSpriteName = 'animals/running_horses[4]';
  $._spriteIndex = 0;

  $._hitboxX = 0;
  $._hitboxY = 0;
  $._hitboxWidth = 48;
  $._hitboxHeight = 32;

  $._price = 4000;

  $._offsetX = 0;
  $._offsetY = 0;

  $.isHorse = true;

  $.processCreatureNewDay = function(creature) {
    if (creature.mapId === Maps.ANIMAL_CAMP) {
      creature.upsetLevel -= 1;
      this.reduceStress(creature);
      return;
    }

    if (!BarnMap.consumeAnimalFoodInMap(creature.mapId)) {
      if (!Managers.Map.mapIsFarm(creature.mapId)) {
        creature.upsetLevel += 1;
        return;
      }

      if (Managers.Weather.isBadWeather() || Managers.Weather.wasBadWeather()) {
        creature.upsetLevel += 0.5;
        return;
      }

      creature.upsetLevel -= 1;
    }

    this.reduceStress(creature);
    if (creature.upsetLevel > 10) {
      creature.upsetLevel = 10;
    }
  };
})(Creatures.Horse);

Creatures.Horse2 = MVC.deepClone(Creatures.Horse);
Creatures.Horse3 = MVC.deepClone(Creatures.Horse);
Creatures.Horse4 = MVC.deepClone(Creatures.Horse);
Creatures.Horse5 = MVC.deepClone(Creatures.Horse);
Creatures.Horse6 = MVC.deepClone(Creatures.Horse);
Creatures.Horse7 = MVC.deepClone(Creatures.Horse);
Creatures.Horse8 = MVC.deepClone(Creatures.Horse);

Creatures.Horse2.creatureName = 'horse2';
Creatures.Horse2._spriteIndex = 1;

Creatures.Horse3.creatureName = 'horse3';
Creatures.Horse3._spriteIndex = 2;

Creatures.Horse4.creatureName = 'horse4';
Creatures.Horse4._spriteIndex = 3;

Creatures.Horse5.creatureName = 'horse5';
Creatures.Horse5._spriteIndex = 4;

Creatures.Horse6.creatureName = 'horse6';
Creatures.Horse6._spriteIndex = 5;

Creatures.Horse7.creatureName = 'horse7';
Creatures.Horse7._spriteIndex = 6;

Creatures.Horse8.creatureName = 'horse8';
Creatures.Horse8._spriteIndex = 7;

Managers.Creatures.registerCreature(Creatures.Horse);
Managers.Creatures.registerCreature(Creatures.Horse2);
Managers.Creatures.registerCreature(Creatures.Horse3);
Managers.Creatures.registerCreature(Creatures.Horse4);
Managers.Creatures.registerCreature(Creatures.Horse5);
Managers.Creatures.registerCreature(Creatures.Horse6);
Managers.Creatures.registerCreature(Creatures.Horse7);
Managers.Creatures.registerCreature(Creatures.Horse8);