require('game/creatures/Animal');
require('game/managers/Creature');
require('engine/core/MVCommons');

Creatures.Chicken = MVC.deepClone(Creatures.Animal);

(function($){
  $.creatureName = 'chicken';
  $.creatureKindName = 'chicken';
  $.creatureKindEnabled = true;

  $._spriteName = 'animals/chicken';
  $._spriteIndex = 0;

  $._hitboxX = 0;
  $._hitboxY = 0;
  $._hitboxWidth = 32;
  $._hitboxHeight = 32;
  $._offsetX = 0;
  $._offsetY = 0;

  $._price = 1500;

  $.isChicken = true;

  $.checkStatBoundaries = function(creature, increaseMax = false) {
    let maxLuck = creature._maxLuck || (creature._chickenLuck + 1);
    let maxSpeed = creature._maxSpeed || (creature._chickenSpeed + 2);
    let maxEggChance = creature._maxEggChance || (creature._chickenEggChance + 2);

    if (increaseMax) {
      switch(Math.randomInt(10)) {
        case 2:
          maxLuck += 0.01;
          break;
        case 4:
          maxSpeed += 0.01;
          break;
        case 6:
          maxEggChance += 0.01;
          break;
      }
    }

    creature._maxLuck = Math.min(5, maxLuck);
    creature._maxSpeed = Math.min(5, maxSpeed);
    creature._maxEggChance = Math.min(5, maxEggChance);

    if (creature._chickenSpeed > maxSpeed) {
      creature._chickenSpeed = maxSpeed;
    }

    if (creature._chickenEggChance > maxEggChance) {
      creature._chickenEggChance = maxEggChance;
    }

    if (creature._chickenLuck > maxLuck) {
      creature._chickenLuck = maxLuck;
    }
  };

  $.processCreatureNewDay = function(creature) {
    if (creature.mapId === Maps.ANIMAL_CAMP) {
      if (Math.random() * 3 < creature._chickenLuck) {
        creature._chickenSpeed += 0.01;
      }
      if (Math.random() * 3 < creature._chickenLuck) {
        creature._chickenEggChance += 0.005;
      }

      this.checkStatBoundaries(creature, true);
      return;
    }

    const coopMap = Managers.Map.getClass(Maps.COOP);

    if (!coopMap.consumeAnimalFoodInMap(creature.mapId)) {
      if (!Managers.Map.mapIsFarm(creature.mapId)) {
        creature.friendship -= 10;
        return;
      }

      if (Managers.Weather.isBadWeather() || Managers.Weather.wasBadWeather()) {
        creature.friendship -= 10;
        return;
      }

      creature.friendship += 2;
      if (Math.random() * 5 < creature._chickenLuck) {
        creature._chickenSpeed += 0.01;
      }

      if (Math.random() * 5 < creature._chickenLuck) {
        creature._chickenEggChance += 0.005;
      }

      const maxFriendship = Managers.Relationship.getMaxFriendship();
      const chance = creature.friendship * 50 / maxFriendship;
      if (Math.randomInt(100) < chance) {
        creature._chickenLuck += 0.01;
      }

      this.checkStatBoundaries(creature);
    }

    creature.friendship += 1;
    if (!coopMap.addEggToMap(creature.mapId, creature)) {
      Managers.FarmObjects.createItemAt(creature.mapId, creature.x, creature.y, 'egg', 1);
    }
  };

  $.processNewCreatureInstance = function(creature) {
    creature._chickenSpeed = 0.1 + Math.randomInt(20) / 10;
    creature._chickenEggChance = 0.1 + Math.randomInt(20) / 10;
    creature._chickenLuck = 0.1 + Math.randomInt(20) / 10;
  };
})(Creatures.Chicken);

Creatures.GreenChicken = MVC.deepClone(Creatures.Chicken);
Creatures.DarkChicken = MVC.deepClone(Creatures.Chicken);
Creatures.CinnamonChicken = MVC.deepClone(Creatures.Chicken);
Creatures.BrownChicken = MVC.deepClone(Creatures.Chicken);
Creatures.RedChicken = MVC.deepClone(Creatures.Chicken);
Creatures.GrayChicken = MVC.deepClone(Creatures.Chicken);
Creatures.OrangeChicken = MVC.deepClone(Creatures.Chicken);
Creatures.PirateChicken = MVC.deepClone(Creatures.Chicken);

Creatures.DarkChicken.creatureName = 'dark-chicken';
Creatures.DarkChicken._spriteIndex = 2;

Creatures.CinnamonChicken.creatureName = 'cinnamon-chicken';
Creatures.CinnamonChicken._spriteIndex = 6;

Creatures.BrownChicken.creatureName = 'brown-chicken';
Creatures.BrownChicken._spriteIndex = 4;

Creatures.RedChicken.creatureName = 'red-chicken';
Creatures.RedChicken._spriteIndex = 5;

// Keeping the class alive for compatibility with older saves, but this chicken can't be obtained anymore
// now it's just a copy of another chicken
Creatures.GrayChicken.creatureName = 'gray-chicken';
Creatures.GrayChicken._spriteIndex = 6;


Creatures.GreenChicken.creatureName = 'green-chicken';
Creatures.GreenChicken._spriteIndex = 1;

Creatures.PirateChicken.creatureName = 'pirate-chicken';
Creatures.PirateChicken._spriteIndex = 3;

Creatures.OrangeChicken.creatureName = 'orange-chicken';
Creatures.OrangeChicken._spriteIndex = 7;

Managers.Creatures.registerCreature(Creatures.Chicken);
Managers.Creatures.registerCreature(Creatures.GreenChicken);
Managers.Creatures.registerCreature(Creatures.DarkChicken);
Managers.Creatures.registerCreature(Creatures.CinnamonChicken);
Managers.Creatures.registerCreature(Creatures.BrownChicken);
Managers.Creatures.registerCreature(Creatures.RedChicken);
Managers.Creatures.registerCreature(Creatures.GrayChicken);
Managers.Creatures.registerCreature(Creatures.OrangeChicken);
Managers.Creatures.registerCreature(Creatures.PirateChicken);