require('game/creatures/Animal');
require('game/managers/Creature');
require('engine/core/MVCommons');

Creatures.Chick = MVC.deepClone(Creatures.Animal);

(function($){
  $.creatureName = 'chick';
  $.creatureKindName = 'chicken';
  $.creatureKindEnabled = true;

  $._spriteName = 'animals/chick';
  $._spriteIndex = 0;

  // $._hitboxX = 17;
  // $._hitboxY = 34;
  // $._hitboxWidth = 30;
  // $._hitboxHeight = 30;
  $._offsetX = 0;
  $._offsetY = -10;

  $.isChick = true;
  $._price = 1000;

  $.processCreatureNewDay = function(creature) {
    if (creature.mapId === Maps.ANIMAL_CAMP) {
      creature.growthStage++;
      return;
    }

    const coopMap = Managers.Map.getClass(Maps.COOP);
    if (!coopMap.consumeAnimalFoodInMap(creature.mapId)) {
      if (!Managers.Map.mapIsFarm(creature.mapId)) {
        creature.friendship -= 5;
        return;
      }

      if (Managers.Weather.isBadWeather() || Managers.Weather.wasBadWeather()) {
        creature.friendship -= 10;
        return;
      }
    }

    this.friendship += 1;

    if (creature.growthStage === undefined) {
      creature.growthStage = 0;
    }

    creature.growthStage++;

    if (creature.growthStage >= 4) {
      creature.type = creature.type.replace(/\bchick\b/, 'chicken');
    }
  };

  $.processNewCreatureInstance = function(creature) {
    creature._chickenSpeed = 0.1 + Math.randomInt(25) / 10;
    creature._chickenEggChance = 0.1 + Math.randomInt(25) / 10;
    creature._chickenLuck = 0.1 + Math.randomInt(25) / 10;
  };
})(Creatures.Chick);

Creatures.GreenChick = MVC.deepClone(Creatures.Chick);
Creatures.DarkChick = MVC.deepClone(Creatures.Chick);
Creatures.CinnamonChick = MVC.deepClone(Creatures.Chick);
Creatures.BrownChick = MVC.deepClone(Creatures.Chick);
Creatures.RedChick = MVC.deepClone(Creatures.Chick);
Creatures.GrayChick = MVC.deepClone(Creatures.Chick);
Creatures.OrangeChick = MVC.deepClone(Creatures.Chick);
Creatures.PirateChick = MVC.deepClone(Creatures.Chick);

Creatures.DarkChick.creatureName = 'dark-chick';
Creatures.DarkChick._spriteIndex = 3;

Creatures.CinnamonChick.creatureName = 'cinnamon-chick';
Creatures.CinnamonChick._spriteIndex = 6;

Creatures.BrownChick.creatureName = 'brown-chick';
Creatures.BrownChick._spriteIndex = 4;

Creatures.RedChick.creatureName = 'red-chick';
Creatures.RedChick._spriteIndex = 5;

Creatures.GrayChick.creatureName = 'gray-chick';
Creatures.GrayChick._spriteIndex = 6;

Creatures.GreenChick.creatureName = 'green-chick';
Creatures.GreenChick._spriteIndex = 1;

Creatures.PirateChick.creatureName = 'pirate-chick';
Creatures.PirateChick._spriteIndex = 2;

Creatures.OrangeChick.creatureName = 'orange-chick';
Creatures.OrangeChick._spriteIndex = 7;

Managers.Creatures.registerCreature(Creatures.Chick);
Managers.Creatures.registerCreature(Creatures.GreenChick);
Managers.Creatures.registerCreature(Creatures.DarkChick);
Managers.Creatures.registerCreature(Creatures.CinnamonChick);
Managers.Creatures.registerCreature(Creatures.BrownChick);
Managers.Creatures.registerCreature(Creatures.RedChick);
Managers.Creatures.registerCreature(Creatures.GrayChick);
Managers.Creatures.registerCreature(Creatures.OrangeChick);
Managers.Creatures.registerCreature(Creatures.PirateChick);