/* eslint no-useless-escape: 0 */
const splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
const splitPath = function(fileName) {
  return splitPathRe.exec(fileName).slice(1);
};

if (window.require) {
  window.fs = require('fs');
  window.path = require('path');
  window.gui = require('nw.gui');
} else {
  // #ToDo: something needs to be done here
}

class Wrapper { // eslint-disable-line no-unused-vars
  static joinFileNames(...args) {
    if (window.path) {
      return window.path.join.apply(this, args);
    }

    const pathList = [];
    for (let i = 0; i < args.length; i++) {
      const pathPart = args[i];
      if (!pathPart) continue;

      const pieces = pathPart.split(/[\\\/]/);
      for (let j = 0; j < pieces.length; j++) {
        const piece = pieces[j];

        if (piece == '.') continue;
        if (piece == '..') {
          if (pathList.length) {
            pathList.pop();
            continue;
          }
        }

        pathList.push(piece);
      }
    }

    return pathList.join('/');
  }

  static dirname(...args) {
    if (window.path) {
      return window.path.dirname.apply(this, args);
    }

    const dirname = (name) => {
      var result = splitPath(name),
        root = result[0],
        dir = result[1];

      if (!root && !dir) {
        // No dirname whatsoever
        return '.';
      }

      if (dir) {
        // It has a dirname, strip trailing slash
        dir = dir.substr(0, dir.length - 1);
      }

      return root + dir;
    };

    return dirname(...args);
  }

  static basename(...args) {
    if (window.path) {
      return window.path.basename.apply(this, args);
    }

    const basename = (path, ext) => {
      var f = splitPath(path)[2];
      // TODO: make this comparison case-insensitive on windows?
      if (ext && f.substr(-1 * ext.length) === ext) {
        f = f.substr(0, f.length - ext.length);
      }
      return f;
    };

    return basename(...args);
  }

  static extname(...args) {
    if (window.path) {
      return window.path.extname.apply(this, args);
    }

    return splitPath(...args)[3];
  }

  static readFileSync(fileName) {
    if (window.fs) {
      return window.fs.readFileSync(fileName, 'utf-8');
    }

    throw new Error(`Unable to read file ${ fileName }`);
  }

  static readFile(fileName, callback) {
    if (window.fs) {
      return window.fs.readFile(fileName, { encoding: 'utf-8'}, (error, data) => {
        if (error) {
          throw new Error(error);
        }

        callback(data);
      });
    }

    let xhr = new XMLHttpRequest();
    xhr.responseType = 'text';
    xhr.onloadend = (data) => {
      callback(xhr.responseText);
    };
    xhr.open('GET', fileName, true);
    xhr.send(null);
  }

  static readdirSync(folderPath) {
    if (window.fs) {
      return window.fs.readdirSync(folderPath);
    }

    const indexFile = this.joinFileNames(folderPath, 'folder.ffindex');
    const indexData = this.readFileSync(indexFile);

    if (!indexData) {
      return [];
    }

    const fileList = indexData.split('\n');
    return fileList;
  }

  static existsSync(filePath) {
    if (window.fs) {
      return window.fs.existsSync(filePath);
    }

    //#ToDo
    return false;
  }

  static isDirectory(fullPath) {
    if (window.fs) {
      return window.fs.lstatSync(fullPath).isDirectory();
    }

    throw new Error(`Unable to determine if path is a directory ${ fullPath }`);
  }
}