const Window_BasicTransition = require('./BasicTransition');

class Window_LeftToRightTransition extends Window_BasicTransition {
  initialize(x, y, width, height, speed, timeout) {
    super.initialize(x, y, width, height);
    this._maxValue = width;
    this._currentValue = 0;
    this._speed = speed || 5;
    this._timeout = timeout || 0;

    this._edgeImage = Managers.Images.loadSystem('l2r-transition-edge');
  }

  isDone() {
    return this._currentValue >= (this._maxValue + this._speed);
  }

  update() {
    if (!this._edgeImage.isReady()) {
      return;
    }

    if (this._timeout > 0) {
      this._timeout--;
      return;
    }

    const edgeWidth = this._edgeImage.width;
    const edgeHeight = this._edgeImage.height;
    const canvasHeight = this.contents.height;
    const canvasWidth = this.contents.width;

    this.contents.clear();
    this.contents.fillRect(0, 0, Math.floor(this._currentValue), canvasHeight, '#FFAB57');

    if (this._currentValue <= canvasWidth + (this._speed || 5)) {
      this.contents._context.globalCompositeOperation = 'source-over';
      this.contents._context.imageSmoothingEnabled = false;

      let y = 0;
      let x = Math.floor(this._currentValue);

      while (y < canvasHeight) {
        this.contents._context.drawImage(this._edgeImage._image, 0, 0, edgeWidth, edgeHeight, x, y, edgeWidth, edgeHeight);
        y += edgeHeight;
      }

      this.contents._setDirty();
      this._currentValue += (this._speed || 5) * Graphics.windowZoomLevel;
    }
  }
}

module.exports = Window_LeftToRightTransition;