const Window_LeftToRightTransition = require('./LeftToRight');

class Window_GameBootTransition extends Window_LeftToRightTransition {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height, 8, Utils.getFrameCount(60));

    this._tropicalLogo = Managers.Images.loadTitle1('TropicalLogo');
    this._currentScale = 0;
    this._targetScale = Math.max(1, Math.floor(Graphics.width / 640));
    this._finishedLogo = false;
    this._logoTimeout = Utils.getFrameCount(120);
  }

  isDone() {
    if (!super.isDone()) {
      return false;
    }

    if (!this._finishedLogo) {
      return false;
    }

    if (this._logoTimeout > 0) {
      return false;
    }

    return true;
  }

  updateLogo() {
    if (this._currentScale < this._targetScale) {
      this._currentScale += 0.05 * this._targetScale / 2;
    }

    if (this._currentScale >= this._targetScale) {
      this._currentScale = this._targetScale;
      this._finishedLogo = true;
    }

    if (this._currentScale) {
      const sw = this._tropicalLogo.width;
      const sh = this._tropicalLogo.height;

      const dw = sw * this._currentScale;
      const dh = sh * this._targetScale;

      const canvasWidth = this.contents.width;
      const canvasHeight = this.contents.height;

      const dx = Math.floor((canvasWidth / 2) - (dw / 2));
      const dy = Math.floor((canvasHeight / 2) - (dh / 2));

      this.contents.bltImage(this._tropicalLogo, 0, 0, sw, sh, dx, dy, dw, dh);

      if (this._finishedLogo) {
        const textY = Math.floor((Graphics.height / 2) + (dh / 2)) + this.lineHeight();

        this.contents.outlineWidth = 0;
        this.drawText("Created By:", 0, textY, Graphics.width / 2, 'right');
        this.drawText("  Hudell", Graphics.width / 2, textY, Graphics.width / 2, 'left');

        this.drawText("Main Artist:", 0, textY + (this.lineHeight()), Graphics.width / 2, 'right');
        this.drawText("  Ryan Kamos", Graphics.width / 2, textY + (this.lineHeight()), Graphics.width / 2, 'left');

        this.drawText("Music By:", 0, textY + (this.lineHeight() * 2), Graphics.width / 2, 'right');
        this.drawText("  Dale North,", Graphics.width / 2, textY + (this.lineHeight() * 2), Graphics.width / 2, 'left');
        this.drawText("    Courtesy of Scarlet Moon Artists", Graphics.width / 2, textY + (this.lineHeight() * 3), Graphics.width / 2, 'left');

        if (this._bootStatus) {
          this.drawText(this._bootStatus, 0, Graphics.height - this.lineHeight(), Graphics.width, 'left');
        }
      }
    }
  }

  update() {
    if (Engine.Utils.isOptionValid('test') && Engine.Input.isPressed('shift')) {
      this._currentValue = this._maxValue + this._speed;
      this._logoTimeout = 0;
      this._currentScale = this._targetScale;
      this._timeout = 0;
    }

    if (!super.isDone()) {
      super.update();
      return;
    }

    if (!this._finishedLogo) {
      this.updateLogo();
      return;
    }

    if (this._logoTimeout > 0) {
      this._logoTimeout--;
      return;
    }
  }

  standardFontFace() {
    return 'ThinFont';
  }

  changeBootStatus(newStatus) {
    this._bootStatus = newStatus;
    super.update();
    this.updateLogo();
  }
}

module.exports = Window_GameBootTransition;
