const Window_BasicTransition = require('./BasicTransition');

class Window_EarlyAccessTransition extends Window_BasicTransition {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._timeout = Utils.getFrameCount(200);
    this.loadAnimalSprite();
    this._index = 0;
    this._indexTimeout = 60;
  }

  loadAnimalSprite() {
    const possibleSprites = [
      { name: 'LoadingChicken', time: 12 },
      { name: 'LoadingOstrich', time: 12 },
      { name: 'LoadingPig', time: 12 },
      { name: 'LoadingCurupira', time: 16 },
      { name: 'LoadingOrangeMan', time: 16 },
      { name: 'LoadingDonkey', time: 12 },
      { name: 'LoadingShiba1', time: 16 },
      { name: 'LoadingShiba2', time: 2 },
      { name: 'LoadingShiba3', time: 8 },
      { name: 'LoadingShiba4', time: 12 },
      { name: 'LoadingCrop1', time: 45 },
      { name: 'LoadingCrop2', time: 45 },
      { name: 'LoadingCrop3', time: 45 }
    ];

    const idx = Math.randomInt(possibleSprites.length);
    const spriteData = possibleSprites[idx];

    const spriteName = spriteData.name;

    this._animalImage = Managers.Images.loadSystem(spriteName);
    this._animalAnimationTime = spriteData.time;
    this._indexTimeout = Utils.getFrameCount(spriteData.time);
  }

  isDone() {
    if (!this._animalImage.isReady()) {
      return false;
    }

    // If dsv mode and holding shift, skip the animation
    if (Utils.isOptionValid('test') && Engine.Input.isPressed('shift')) {
      return true;
    }

    if (this._timeout > 0) {
      return false;
    }

    return true;
  }

  refresh() {
    const spriteWidth = this._animalImage.width;
    const animalWidth = Math.floor(spriteWidth / 3);
    const animalHeight = this._animalImage.height;
    const canvasHeight = this.contents.height;
    const canvasWidth = this.contents.width;

    const scale = Math.max(1, Math.floor(Graphics.width / 640));

    this.contents.clear();

    const dx = Math.floor((Graphics.width / 2) - (animalWidth * scale / 2));
    const dy = Math.floor((Graphics.height / 2) - (animalHeight * scale));
    const index = this._index == 3 ? 1 : this._index;

    this.contents.fillRect(0, 0, canvasWidth, canvasHeight, '#FFAB57');
    this.contents.bltImage(this._animalImage, 0 + (animalWidth * index), 0, animalWidth, animalHeight, dx, dy, animalWidth * scale, animalHeight * scale);

    const textY = Math.floor(Graphics.height / 2);

    this.contents.outlineWidth = 0;
    this.drawText(t("This game is still in development."), 0, textY, Graphics.width, 'center');
    this.drawText(t("Everything can change in future updates."), 0, textY + this.lineHeight(), Graphics.width, 'center');
  }

  updateState() {
    if (this._indexTimeout > 0) {
      this._indexTimeout--;
    } else {
      this._index++;
      this._indexTimeout = Utils.getFrameCount(this._animalAnimationTime);

      if (this._index > 3) {
        this._index = 0;
      }
    }

    if (this._timeout > 0) {
      this._timeout--;
    }
  }

  update() {
    if (!this._animalImage.isReady()) {
      return;
    }

    this.refresh();
    this.updateState();
  }

  standardFontFace() {
    return 'ThinFont';
  }
}

module.exports = Window_EarlyAccessTransition;