const Window_Base = require('engine/windows/Window_Base');

//-----------------------------------------------------------------------------
// Window_PatchNotes
//
// The window for showing patch notes

class Window_PatchNotes extends Window_Base {
  initialize() {
    const width = 330 * Graphics.windowZoomLevel;
    const height = 322 * Graphics.windowZoomLevel;

    const y = Graphics.height - height;
    const x = (Graphics.width - width) / 2;

    super.initialize(x, y, width, height);
    this.hide();
    this._text = Managers.Updates.getAllPatchNotes();
    this._allTextHeight = 0;
    this._cancelHandler = false;
  }

  enableWindowFrame() {
    return false;
  }

  standardFontFace() {
    return 'ThinFont';
  }

  update() {
    super.update();

    if (!this.active) return;

    const multiplier = 2.5 * Graphics.windowZoomLevel;

    if (Engine.Input.isPressed('down')) {
      this.origin.y += multiplier;
    } else if (Engine.Input.isPressed('up')) {
      this.origin.y -= multiplier;
    } else if (Engine.Input.isPressed('pagedown') || Engine.Input.isPressed('right_backbutton')) {
      this.origin.y += multiplier * 10;
    } else if (Engine.Input.isPressed('pageup') || Engine.Input.isPressed('left_backbutton')) {
      this.origin.y -= multiplier * 10;
    } else if (TouchInput.wheelY >= Constants.WHEELTHRESHOLD) {
      this.origin.y += multiplier * 10;  
    } else if (TouchInput.wheelY <= -Constants.WHEELTHRESHOLD) {
      this.origin.y -= multiplier * 10;
    } else if (this.isCancelTriggered()) {
      if (this._cancelHandler) {
        this._cancelHandler();
      }
    }

    if (this.origin.y < 0) {
      this.origin.y = 0;
    }

    if (this.origin.y > this._allTextHeight - 300) {
      this.origin.y = this._allTextHeight - 300;
    }

    // if (this._text) {
    //   this.updateMessage();
    // }
  }

  setCancelHandler(handler) {
    this._cancelHandler = handler;
  }

  refresh() {
    const textState = { index: 0 };
    const maxHeight = 16384;
    textState.text = this.convertEscapeCharacters(this._text);
    this.resetFontSettings();
    this.contents.outlineWidth = 0;
    this._allTextHeight = Math.min(maxHeight, this.calcTextHeight(textState, true) + 100);


    this.createContents();
    // this.origin.y = -this.height;
    this.drawTextEx(this._text, this.textPadding(), 1);
  }

  contentsHeight() {
    return Math.max(this._allTextHeight, 1);
  }

  updateMessage() {
    // if (Engine.Input.isTriggered('down')) {
    //   this.origin.y += 3;
    // }
    // this.origin.y += this.scrollSpeed();
    // if (this.origin.y >= this.contents.height) {
    //   this.terminateMessage();
    // }
  }

  terminateMessage() {
    this._text = null;
    this.hide();
  }

  standardFontSize() {
    return Utils.convertFontSize(22, Graphics.windowZoomLevel);
  }

  lineHeight() {
    return 16 * Graphics.windowZoomLevel;
  }

  normalColor() {
    return this.blackColor();
  }

  standardOutlineWidth() {
    return 0;
  }
}

module.exports = Window_PatchNotes;
