const Window_Base = require('engine/windows/Window_Base');

//-----------------------------------------------------------------------------
// Window_Credits
//
// The window for showing the game credits

class Window_Credits extends Window_Base {
  initialize() {
    const width = 330 * Graphics.windowZoomLevel;
    const height = 322 * Graphics.windowZoomLevel;

    const y = Graphics.height - height;
    const x = (Graphics.width - width) / 2;

    super.initialize(x, y, width, height);
    this.hide();
    const windowHeight = 322 * Graphics.windowZoomLevel;
    this._allTextHeight = windowHeight * 2.2;
    this._cancelHandler = false;
    this.createContents();
  }

  enableWindowFrame() {
    return false;
  }

  standardFontFace() {
    return 'GameFont';
  }

  update() {
    super.update();

    if (!this.active) return;

    const multiplier = 2.5 * Graphics.windowZoomLevel;

    if (Engine.Input.isPressed('down')) {
      this.origin.y += multiplier;
    } else if (Engine.Input.isPressed('up')) {
      this.origin.y -= multiplier;
    } else if (Engine.Input.isPressed('pagedown') || Engine.Input.isPressed('right_backbutton')) {
      this.origin.y += multiplier * 10;
    } else if (Engine.Input.isPressed('pageup') || Engine.Input.isPressed('left_backbutton')) {
      this.origin.y -= multiplier * 10;
    } else if (TouchInput.wheelY >= Constants.WHEELTHRESHOLD) {
      this.origin.y += multiplier * 10;  
    } else if (TouchInput.wheelY <= -Constants.WHEELTHRESHOLD) {
      this.origin.y -= multiplier * 10;
    } else if (this.isCancelTriggered()) {
      if (this._cancelHandler) {
        this._cancelHandler();
      }
    }

    if (this.origin.y < 0) {
      this.origin.y = 0;
    }

    if (this.origin.y > this._allTextHeight - 300 * Graphics.windowZoomLevel) {
      this.origin.y = this._allTextHeight - 300 * Graphics.windowZoomLevel;
    }
  }

  setCancelHandler(handler) {
    this._cancelHandler = handler;
  }

  refresh() {
    this.createContents();

    this.contents.fontSize = Utils.convertFontSize(44, Graphics.windowZoomLevel);
    this.changeTextColor('#FB3153');

    let x = 0;
    let y = 0;
    const w = this.contents.width;
    this.drawText('Fantasy Farming: Orange Season', 0, 0, w, 'center');

    this.resetFontSettings();

    const lineHeight = this.lineHeight();
    y = lineHeight;

    const addLine = (name, position) => {
      this.resetTextColor();
      if (position) {
        this.drawText(t(position), x, y, w, 'right');
        this.contents.fillRect(x, y + lineHeight, w, Graphics.windowZoomLevel, '#D7A678');
      }

      this.drawText(name, x, y, w, 'left');
      y += lineHeight;
    };

    const addExtra = (name, description) => {
      this.resetTextColor();
      if (description) {
        this.contents.fontSize = Utils.convertFontSize(22, Graphics.windowZoomLevel);
        this.drawText(t(description), x, y + 3 * Graphics.windowZoomLevel, w, 'right');
        this.contents.fillRect(x, y + lineHeight, w, Graphics.windowZoomLevel, '#D7A678');
      }

      this.contents.fontSize = this.standardFontSize();
      this.drawText(name, x, y, w, 'left');
      y += lineHeight;
    };

    y += lineHeight;
    this.contents.fontSize = Utils.convertFontSize(40, Graphics.windowZoomLevel);
    this.changeTextColor('#328FFA');
    this.drawText(t("Tropical Puppy Team") + ':', x, y, w, 'center');
    y += lineHeight * 1;
    this.drawText('www.tropicalpuppy.com', x, y, w, 'center');
    y += lineHeight * 1.5;

    this.resetFontSettings();
    addLine("Pierre Lehnen", "Main Developer");
    addLine("Marcos Freire", "Art Director");
    addLine("Rafael Magnino", "Writer");
    addLine("Bruno Nicodemos", "Tester");

    y += lineHeight;
    this.contents.fontSize = Utils.convertFontSize(40, Graphics.windowZoomLevel);
    this.changeTextColor('#328FFA');
    this.drawText(t("Third Parties") + ':', x, y, w, 'center');
    y += lineHeight * 1.5;

    this.resetFontSettings();
    addLine("Dale North", "Music");

    y += lineHeight;
    this.contents.fontSize = Utils.convertFontSize(40, Graphics.windowZoomLevel);
    this.changeTextColor('#328FFA');
    this.drawText(t("Including Work By") + ':', x, y, w, 'center');
    y += lineHeight * 1.5;

    this.resetFontSettings();
    addExtra("Lanea Zimmerman", "\"Pixel Myth Germania\" asset pack");
    addExtra("Celianna", "\"Rural Farm Tiles\" asset pack");
    addExtra("WhtDragon", "Several animal assets");
    addExtra("Sizenko Alexander", "\"ZX Spectrum-7\" font");
    addExtra("KanaX", "Alpha testing and image editing");
    addExtra("Avery", "Image assets");
    addExtra("Candacis", "Image assets");
    addExtra("Momofumi", "Image assets");
    addExtra("Daniel Eddeland", "Image assets");
    addExtra("Casper Nilsson", "Image assets");
    addExtra("RavenTDA", "Image assets");
    addExtra("Yanfly", "Text manipulation scripts");
    addExtra("Aries", "Weather control scripts");
    addExtra("CactusBear", "Sound Effects");
    addExtra("KingGerar", "Image editing");
    addExtra("TheQueenZelda", "Promotional art");

    y += lineHeight;
    this.contents.fontSize = Utils.convertFontSize(40, Graphics.windowZoomLevel);
    this.changeTextColor('#328FFA');
    this.drawText(t("Special Thanks") + ':', x, y, w, 'center');
    y += lineHeight * 1.5;
    
    addExtra("GoldenGryphon");
    addExtra("CeliriaRose");
    addExtra("Kerantli");
    addExtra("JeStErHALLOW");
    addExtra("CRMagic");
    addExtra("Rafael Sol Maker");
    addExtra("Sylvester");
    addExtra("Ishorta");
    addExtra("Lucas Kich");
  }

  contentsHeight() {
    if (this._allTextHeight) {
      return this._allTextHeight;
    }
    return super.contentsHeight();
  }

  standardFontSize() {
    return Utils.convertFontSize(36, Graphics.windowZoomLevel);
  }

  lineHeight() {
    return 16 * Graphics.windowZoomLevel;
  }

  normalColor() {
    return this.blackColor();
  }

  standardOutlineWidth() {
    return 0;
  }

  show() {
    super.show();
    this.origin.y = 1;
    this.refresh();
  }
}

module.exports = Window_Credits;
