const Window_BaseItemInfo = require('../core/BaseItemInfo');

class Window_ShopItemInfo extends Window_BaseItemInfo {
  initialize(x, y) {
    const width = 180 * Graphics.windowZoomLevel;
    const height = 136 * Graphics.windowZoomLevel;

    super.initialize(x, y, width, height);
    this._zoomLevel = Graphics.windowZoomLevel;
  }

  drawBackground() {
    const bitmap = Managers.Images.loadBackground('layout_shop_info');

    if (!bitmap.isReady()) {
      this.requireBitmap(bitmap);
      return;
    }

    this.drawBitmap(bitmap, 0, 0, this._zoomLevel);
  }

  labelWidth() {
    return 125 * Graphics.windowZoomLevel;
  }

  labelX() {
    return 11 * Graphics.windowZoomLevel;
  }

  valueWidth() {
    return 38 * Graphics.windowZoomLevel;
  }

  valueX() {
    return 138 * Graphics.windowZoomLevel;
  }
}

module.exports = Window_ShopItemInfo;