const ShopNumberSubWindow = require('./ShopNumberSubWindow');

class Window_ShopItem extends ShopNumberSubWindow {
  initialize() {
    const x = (Graphics.width - this.windowWidth()) / 2;
    const y = (Graphics.height / 2) - 86 * Graphics.windowZoomLevel;

    super.initialize(x, y);
  }

  windowWidth() {
    return 166 * Graphics.windowZoomLevel;
  }

  windowHeight() {
    return 97 * Graphics.windowZoomLevel;
  }

  topMargin() {
    return 27 * Graphics.windowZoomLevel;
  }

  leftMargin() {
    return 5 * Graphics.windowZoomLevel;
  }

  drawContentBackground() {
    const bitmap = Managers.Images.loadBackground('layout_popup_shop');
    this.drawBitmap(bitmap, 0, 0, Graphics.windowZoomLevel);
  }
}

module.exports = Window_ShopItem;
