const Window_PopupCommand = require('../core/PopupCommand');

class Window_ShopCommand extends Window_PopupCommand {
  initialize() {
    this._mode = 'buy';
    super.initialize();
  }

  makeCommandList() {
    switch(this._mode) {
      case 'buy':
        this.addCommand(t('Buy'), 'buy');
        break;
      case 'retrieve':
        this.addCommand(t('Retrieve'), 'retrieve');
        break;
      case 'send':
        this.addCommand(t('Send'), 'send');
        break;
      case 'race':
        this.addCommand(t('Race'), 'race');
        break;
      default:
        this.addCommand(t('Sell'), 'sell');
        break;
    }

    this.addCommand(t('Cancel'), 'cancel');
  }

  popupBackgroundName() {
    return 'popup2';
  }

  windowHeight() {
    return 80 * Graphics.windowZoomLevel;
  }

  setMode(newMode) {
    this._mode = newMode;
    this.refresh();
  }
}

module.exports = Window_ShopCommand;