const Window_Selectable = require('engine/windows/Window_Selectable');
const AnimalWindowHelper = require('../contexts/AnimalWindowHelper');

class Window_AnimalsToSend extends Window_Selectable {
  initialize() {
    this._zoomLevel = Graphics.windowZoomLevel;

    const height = 274 * this._zoomLevel;
    const width = 274 * this._zoomLevel;
    const x = (Graphics.width - width) / 2;
    const y = (Graphics.height - height) / 2;

    this.makeItemList();

    super.initialize(x, y, width, height);
    this.refresh();
    this.select(0);
    this.activate();
  }

  setButtonText(newText) {
    this._buttonText = newText;
  }

  enableWindowFrame() {
    return false;
  }

  enableCursorSprite() {
    return false;
  }

  topMargin() {
    return 29 * this._zoomLevel;
  }

  bottomMargin() {
    return 0;
  }

  horizontalMargin() {
    return 27 * this._zoomLevel;
  }

  maxItems() {
    return this._animalList.length;
  }

  maxCols() {
    return 1;
  }

  standardFontSize() {
    return Utils.convertFontSize(20, this._zoomLevel);
  }

  animal() {
    var idx = this.index();
    if (idx >= 0 && idx < this._animalList.length) {
      return this._animalList[idx];
    }

    return undefined;
  }

  refresh() {
    this.makeItemList();
    this.createContents();

    this.redraw();
  }

  redraw() {
    this.contents.clear();

    this._needsRedraw = false;

    this.drawBackground();
    this.drawAllItems();
  }

  update() {
    super.update();

    if (this._needsRedraw === true) {
      this.redraw();
    } else if (this._needsRedraw) {
      this.requireBitmap(this._needsRedraw);
    }
  }

  select(index) {
    super.select(index);
    this._needsRedraw = true;
  }

  drawBackground() {
    const bitmap = Managers.Images.loadBackground('animal_vet_layout');
    if (!bitmap.isReady()) {
      this._needsRedraw = bitmap;
      return;
    }

    this.drawBitmap(bitmap, 0, 0, this._zoomLevel);
  }

  itemHeight() {
    return 58 * this._zoomLevel;
  }

  makeItemList() {
    this._animalList = Managers.Creatures.getAnimalsForCampList();
    // for (let i = 0; i < this._typeList.length; i++) {
    //   const creatureType = Managers.Creatures.getCreatureType(this._typeList[i]);

    //   if (!creatureType) continue;

    //   this._animalList.push(creatureType);
    //   Managers.Images.loadPicture('menu/animals/' + creatureType.creatureName);
    // }
  }

  drawItem(index) {
    const rect = this.itemRect(index);

    this.contents.fontSize = Utils.convertFontSize(26, this._zoomLevel);

    const bitmap = Managers.Images.loadPicture('shop/animal_vet_retrieve_slot');
    if (bitmap.isReady()) {
      this.drawZoomedBitmap(bitmap, rect.x, rect.y, this._zoomLevel);
    }

    this.resetTextColor();

    if (index < 0) return;

    const animalData = this._animalList[index];
    if (!animalData) {
      return;
    }

    const { x, y } = rect;

    const faceBitmap = Managers.Images.loadPicture('menu/animals/' + animalData._type);

    if (faceBitmap.isReady()) {
      rect.width = 60 * this._zoomLevel;
      rect.y += 4 * this._zoomLevel;
      AnimalWindowHelper.drawAnimalBadge(this, rect, animalData, this._zoomLevel, false, false, -12 * this._zoomLevel);
    } else {
      this._needsRedraw = faceBitmap;
    }

    this.contents.outlineWidth = 0;
    this.changeTextColor(this.blackColor);

    const buttonX = x + 174 * this._zoomLevel;
    const buttonY = y + 38 * this._zoomLevel;
    const buttonW = 40 * this._zoomLevel;
    const buttonH = 12 * this._zoomLevel;
    let buttonColor = this.blueColor();
    let buttonText = this._buttonText || t("Send");

    this.contents.fillRect(buttonX, buttonY, buttonW, buttonH, buttonColor);

    this.changeTextColor(this.baseColor());
    this.drawText(buttonText.toUpperCase(), buttonX, buttonY + 2 * this._zoomLevel - (this.contents.fontSize / 2), buttonW, 'center');

    if (index == this._index) {
      const cursorBitmap = Managers.Images.loadPicture('menu/cursor');
      if (cursorBitmap.isReady()) {
        this.drawZoomedBitmap(cursorBitmap, x + 223 * this._zoomLevel, y + 27 * this._zoomLevel, this._zoomLevel);
      } else {
        this._needsRedraw = cursorBitmap;
      }
    }
  }

  extraLineHeight() {
    return 0;
  }

  normalColor() {
    return this.blackColor();
  }

  standardOutlineWidth() {
    return 0;
  }

  isCurrentItemEnabled() {
    if (this._index < 0) return false;

    const animalData = this._animalList[this._index];
    if (!animalData) return false;

    return true;
  }

  standardPadding() {
    return 0;
  }

  spacing() {
    return 0;
  }
}

module.exports = Window_AnimalsToSend;