const BaseStampListWindow = require('./BaseStampListWindow');

class Window_TaskList extends BaseStampListWindow {
  makeItemList() {
    this._taskList = Managers.Tasks.getActiveTaskGroups();
  }

  getList() {
    return this._taskList;
  }

  drawItem(index) {
    if (index < 0) return;
    this.resetTextColor();
    const rect = this.itemRect(index);
    const taskId = this._taskList[index];
    const zoom = Graphics.windowZoomLevel;

    const title = Managers.Tasks.getTaskGroupTitle(taskId);

    let arrowMargin = 0;

    if (this._arrowRightBitmap.isReady() && index == this._index) {
      arrowMargin = (this._arrowRightBitmap.width + 2) * zoom;
      this.drawBitmap(this._arrowRightBitmap, rect.x / zoom, rect.y / zoom + 3, zoom);

      this.changeTextColor('#fb3153');
    }

    const textWidth = (150 * zoom) - arrowMargin;
    this.drawText(title, rect.x + arrowMargin, rect.y, textWidth, 'left');

    const status = Managers.Tasks.getTaskGroupStatus(taskId);
    let statusText = '';
    if (status == TaskStatus.ACCEPTED) {
      statusText = t("STARTED");
    } else if (status == TaskStatus.COMPLETED) {
      statusText = t("COMPLETED");
    }

    const statusWidth = 80 * zoom;
    const statusX = rect.x + textWidth + 10 * zoom + arrowMargin * 2;

    if (statusText) {
      this.drawText(statusText, statusX, rect.y, statusWidth, 'left');
    }

    if (index == this._index) {
      this.contents.fillRect(rect.x + arrowMargin, rect.y + rect.height - 1 * zoom, rect.width - arrowMargin, 1 * zoom, '#fb3153');
      this.changeTextColor('#328ffa');

      const npcName = Managers.Tasks.getTaskGroupVillager(taskId) || false;
      if (npcName) {
        const requesterLabel = t("Requested By") + ': ' + t(npcName);
        this.drawText(requesterLabel, rect.x + arrowMargin, rect.y + this.lineHeight(), textWidth, 'left');
      }

      const date = Managers.Tasks.getGroupTaskDate(taskId, status == TaskStatus.COMPLETED);
      if (date) {
        const dateConfig = Managers.Time.convertTimestampToConfig(date);
        if (dateConfig) {
          const dateStr = Managers.Time.getFormattedDate(dateConfig);

          this.drawText(dateStr, statusX, rect.y + this.lineHeight(), statusWidth, 'left');
        }
      }
    }
  }

  itemRect(index) {
    if (this._index >= 0 && this._index < index) {
      return super.itemRect(index + 1);
    }

    return super.itemRect(index);
  }

  maxPageRows() {
    if (this._index >= 0) {
      return super.maxPageRows() -1;
    }

    return super.maxPageRows();
  }
}

module.exports = Window_TaskList;
