const BaseStampListWindow = require('./BaseStampListWindow');

class Window_ShippedItemsList extends BaseStampListWindow {
  makeItemList() {
    const list = [];

    for (let itemData of $dataItems) {
      if (!itemData) continue;
      if (itemData.disabled) continue;
      if (!itemData.sellPrice) continue;

      const quantity = Managers.History.getShippedItems(itemData.id);
      list.push({
        id: itemData.id,
        quantity,
        iconIndex: itemData.iconIndex
      });
    }

    this._itemList = list.sort((item1, item2) => {
      return item2.quantity - item1.quantity;
    });
  }

  getList() {
    return this._itemList;
  }

  drawItemText(index, rect, arrowMargin, data, textWidth) {
    const displayName = Managers.Text.item(data.id);

    this.drawIcon(data.iconIndex, rect.x + arrowMargin, rect.y, Graphics.windowZoomLevel / 2);

    textWidth -= Core.BasicWindow._iconWidth * Graphics.windowZoomLevel / 2;
    arrowMargin += Core.BasicWindow._iconWidth * Graphics.windowZoomLevel / 2;

    this.drawText(displayName, rect.x + arrowMargin, rect.y, textWidth, 'left');
    this.drawText(data.quantity, rect.x + arrowMargin, rect.y, textWidth, 'right');
  }
}

module.exports = Window_ShippedItemsList;