const BaseStampListWindow = require('./BaseStampListWindow');

class Window_ProgressList extends BaseStampListWindow {
  makeItemList() {
    this._progressList = Managers.Content.getCustomDatabaseSummaryLines();
  }

  getList() {
    return this._progressList;
  }

  drawItemText(index, rect, arrowMargin, data, textWidth) {
    this.drawText(data.title, rect.x + arrowMargin, rect.y, textWidth, 'left');
    const weight = data.weight;

    if (weight && data.dataFn) {
      const numbers = data.dataFn();
      if (numbers && numbers.length >= 2) {
        const value = numbers[0];
        const max = numbers[1];

        const currentValue = (Math.floor(value * weight / max * 100) / 100).toFixed(2);
        this.drawText(`${ currentValue } / ${ String(weight).padStart(2, '0') }`, rect.x + arrowMargin, rect.y, textWidth, 'right');
      }
    }
  }

  drawAllItems() {
    super.drawAllItems();

    const rect = this.itemRect(this._progressList.length);
    const total = Engine.Data.calculateGameCompletionRate(this._progressList);

    this.changeTextColor(this.blueColor());
    this.drawText(`${ total }%`, rect.x, rect.y, rect.width, 'right');
  }
}

module.exports = Window_ProgressList;