const BaseStampListWindow = require('./BaseStampListWindow');

class Window_AreaList extends BaseStampListWindow {
  makeItemList() {
    this._areaList = Managers.Map.getDiscoveredAreaList();
  }

  getList() {
    return this._areaList;
  }

  drawItemText(index, rect, arrowMargin, data, textWidth) {
    const displayName = Managers.Map.getMapDisplayName(data);
    this.drawText(displayName, rect.x + arrowMargin, rect.y, textWidth, 'left');
  }
}

module.exports = Window_AreaList;