const Window_BaseContent = require('./BaseContent');

class Window_ToolsContent extends Window_BaseContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
    this._listWindow = null;
  }

  drawContent() {
    let x = 115 * this._zoomLevel;
    let y = 19 * this._zoomLevel;
    let w = 100 * this._zoomLevel;
    let h = Utils.convertFontSize(56, this._zoomLevel);

    this.contents.fontSize = h;
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;

    this.changeTextColor(this.baseColor());
    this.drawText(t("Tools").toUpperCase(), x, y, w, 'center');
    this.resetFontSettings();

    this.contents.fontSize = h;
    this.contents.outlineColor = this.darkBaseColor();
    this.contents.outlineWidth = 0;

    x = 0 * this._zoomLevel;
    w = 100 * this._zoomLevel;

    this.changeTextColor(this.darkBaseColor());
    this.drawText(t("Items").toUpperCase(), x, y, w, 'right');
    this.resetFontSettings();

    let tool;

    if (this._listWindow) {
      tool = this._listWindow.selectedTool();
    }

    if (!tool) {
      this.contents.fillRect(0, 128 * this._zoomLevel, 216 * this._zoomLevel, 117 * this._zoomLevel, this.baseColor());
      return;
    }

    const iconX = 35 * this._zoomLevel;
    const iconY = 143 * this._zoomLevel;

    x = 62 * this._zoomLevel;
    y = 151 * this._zoomLevel;
    w = 113 * this._zoomLevel;
    h = 8 * this._zoomLevel;

    const textX = 35 * this._zoomLevel;
    const textY = 221 * this._zoomLevel;
    const textW = 177 * this._zoomLevel;

    if (!tool.nextId) {
      this.drawIcon(tool.iconIndex, iconX, iconY, this._zoomLevel);
      this.contents.fillRect(x, y, w, h, this.blueColor());

      this.contents.fillRect(0, 175 * this._zoomLevel, 216 * this._zoomLevel, 33 * this._zoomLevel, this.baseColor());

      this.changeTextColor(this.darkBaseColor());
      this.drawTextEx('<WordWrap>' + t("This tool has reached the max level.").toUpperCase(), textX, textY, textW);
      return;
    }

    this.drawIcon(tool.nextIcon, iconX, iconY, this._zoomLevel);
    const progress = Math.floor(tool.exp / 100 * 113);
    this.contents.fillRect(x, y, progress * this._zoomLevel, 8 * this._zoomLevel, this.blueColor());

    this.changeTextColor(this.blackColor());
    this.drawText(`${ Math.floor(tool.exp) }%`, x, y - 8, w, 'center');

    this.changeTextColor(this.darkBaseColor());
    if (tool.exp < 100) {
      this.drawTextEx('<WordWrap>' + t("You do not have enough experience to upgrade this tool.").toUpperCase(), textX, textY, textW);
    } else {
      this.drawTextEx('<WordWrap>' + t("Collect the required items and talk to the blacksmith to upgrade this tool.").toUpperCase(), textX, textY, textW);
    }

    const nextTool = Managers.Items.getItemData(tool.nextId);
    if (nextTool && nextTool.ingredients) {
      x = 25 * this._zoomLevel;
      y = 179 * this._zoomLevel;
      w = 28 * this._zoomLevel;

      for (let ingredient of nextTool.ingredients) {
        const data = Managers.Items.getItemData(ingredient);
        if (!data) {
          continue;
        }

        if (data.type == 'tool') {
          continue;
        }

        this.drawIcon(data.iconIndex, x, y);
        x += w;
      }
    }
  }

  isMouseOverItems() {
    const mouseX = (TouchInput.mouseX - this.x) / Graphics.windowZoomLevel;
    const mouseY = (TouchInput.mouseY - this.y) / Graphics.windowZoomLevel;

    if (mouseX >= 0 && mouseX <= (100)) {
      if (mouseY >= 19 && mouseY <= (19 + 21)) {
        return true;
      }
    }

    return false;
  }

  setToolListWindow(listWindow) {
    this._listWindow = listWindow;
  }

  standardFontSize() {
    return Utils.convertFontSize(22, this._zoomLevel);
  }

  resetTextColor() {
    this.changeTextColor(this.darkBaseColor());
  }

  extraLineHeight() {
    return -2 * Graphics.windowZoomLevel;
  }
}

module.exports = Window_ToolsContent;