const Window_ToolContainer = require('../Window_ToolContainer');
reference('engine/windows/Window_Selectable');

class Window_ToolList extends Window_ToolContainer {
  initialize(x, y, width, height) {
    this.includeEmptyItem = false;
    super.initialize(x, y, width, height);
    this._margin = 0;
    this._contentWindow = null;
  }

  enableWindowFrame() {
    return false;
  }
  includeEmptyItem() {
    return false;
  }
  standardPadding() {
    return 0;
  }
  extraSpacing() {
    return 0;
  }
  spacing() {
    return 4 * Graphics.windowZoomLevel;
  }

  maxCols() {
    return 5;
  }

  itemWidth() {
    const Window_Selectable = require('engine/windows/Window_Selectable');
    return Window_Selectable.prototype.itemWidth.call(this);
  }

  itemHeight() {
    return 27 * Graphics.windowZoomLevel;
  }

  drawEmptyItem(x, y, zoomLevel, index) {
  }

  drawItemBgPicture(item, x, y, zoomLevel, index) {
  }

  selectedTool() {
    const index = this.index();
    if (index < 0) return null;

    return this.getItem(index);
  }

  setContentWindow(contentWindow) {
    this._contentWindow = contentWindow;
  }

  drawSelectedItem() {
    const index = this.index();
    if (index < 0) return;

    const rect = this.itemRect(index);
    const item = this.getItem(index);

    const zoomLevel = Graphics.windowZoomLevel;

    this.drawPicture('menu/selected_slot', rect.x - 1 * zoomLevel, rect.y - 1 * zoomLevel, zoomLevel, true);

    this.drawNormalItem(item, rect.x, rect.y, false, index);
  }

  drawNormalItem(item, x, y, zoomedIn, index) {
    const zoomLevel = Graphics.windowZoomLevel;
    let w = 24 * zoomLevel;
    let h = 24 * zoomLevel;

    if (!!item && !!item.id) {
      this.drawItemBadge(item.iconIndex, x, y, w, h);
    }
  }

  cursorPageup() {
  }

  cursorPagedown() {
  }

  select(index) {
    super.select(index);
    if (this._contentWindow) {
      this._contentWindow.refresh();
    }
  }
}

module.exports = Window_ToolList;
