const Window_Selectable = require('engine/windows/Window_Selectable');

class Window_Stamps extends Window_Selectable {
  initialize(x, y, width, height) {
    this.makeItemList();

    super.initialize(x, y, width, height);
    this._allowTouchWhenInactive = false;
    this.refresh();
  }

  enableWindowFrame() {
    return false;
  }

  numVisibleRows() {
    return 3;
  }

  maxItems() {
    return this._stampList.length;
  }

  itemHeight() {
    return 64 * Graphics.windowZoomLevel;
  }

  drawItem(index) {
    const data = this._stampList[index];
    if (!data) return;
    if (!data.bitmap) return;

    this.requireBitmap(data.bitmap);
    if (!data.bitmap.isReady()) return;

    const rect = this.itemRect(index);
    const source = data.bitmap._image ? data.bitmap._image : data.bitmap._canvas;

    const { x, y } = data;
    const size = 64 * Graphics.windowZoomLevel;

    this.contents._context.globalAlpha = index == this._index ? 1 : 0.3;
    this.contents._context.drawImage(source, x, y, 64, 64, rect.x, rect.y, size, size);

    if (data.id === 'progress') {
      const fontBitmap = Managers.Images.loadPicture('menu/stamp_font');
      this.requireBitmap(fontBitmap);

      const value = Math.floor(parseFloat(data.currentValue, 10));
      const valueY = rect.y + ((rect.height / 2) - (23 * Graphics.windowZoomLevel / 2));
      this.drawPercentValue(rect.x, valueY , value, rect.width, 'center', true);
    }
  }

  maxCols() {
    return 3;
  }

  addDefaultStamp(id, index) {
    const bitmap = Managers.Images.loadPicture('menu/stamps');
    const enabled = this.isStampEnabled(id);
    const baseY = Math.floor(index / 7) * 64;

    const currentValue = this.getStampCurrentValue(id);
    const maxValue = this.getMaxStampValue(id);

    this._stampList.push({
      id,
      bitmap,
      enabled,
      x : (index % 7) * 64,
      y : enabled ? baseY + 128 : baseY,
      currentValue,
      maxValue
    });
  }

  makeItemList() {
    this._stampList = [];

    this.addDefaultStamp('progress', 2);
    this.addDefaultStamp('moneyEarned', 5);
    this.addDefaultStamp('moneySpent', 7);

    this.addDefaultStamp('peopleMet', 9);
    this.addDefaultStamp('animals', 6);
    this.addDefaultStamp('areasFound', 8);
    
    this.addDefaultStamp('recipes', 10);
    this.addDefaultStamp('tasksCompleted', 12);
    this.addDefaultStamp('shippedItems', 3);

    this.addDefaultStamp('fishCaught', 1);

    if (Switches.playedSaciIntroduction) {
      this.addDefaultStamp('sacisFound', 13);
    }
  }

  isStampEnabled(stampId) {
    return Managers.Achievements.isStampEnabled(stampId);
  }

  getStampCurrentValue(stampId) {
    return Managers.Achievements.getStampValue(stampId);
  }

  getMaxStampValue(stampId) {
    return Managers.Achievements.getMaxStampValue(stampId);
  }

  selectedStamp() {
    return this._index >= 0 ? this._stampList[this._index] : undefined;
  }

  drawAllItems() {
    this.contents._context.globalCompositeOperation = 'source-over';
    this.contents._context.imageSmoothingEnabled = false;

    super.drawAllItems();

    this.contents._setDirty();
  }

  select(index) {
    super.select(index);
    this.updateInfoWindow();
    this.refresh();
  }

  setInfoWindow(infoWindow) {
    this._infoWindow = infoWindow;
  }

  updateInfoWindow() {
    if (!this._infoWindow) return;

    this._infoWindow.refresh();
  }

  updateCursor() {
    this.configureEmptyCursor();
  }
}

module.exports = Window_Stamps;
