const Window_BaseDiaryContent = require('./BaseContent');

class Window_StampContent extends Window_BaseDiaryContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
  }

  drawContent() {
    if (!this._listWindow) return;

    this.resetFontSettings();

    const stampData = this._listWindow.selectedStamp();
    if (!stampData) return;

    const zoom = Graphics.windowZoomLevel;

    const x = 6 * zoom;
    const w = 204 * zoom;

    const label = Managers.Text.stamp(stampData.id);

    this.drawText(label, x, 0, w, 'center');

    const { currentValue, maxValue } = stampData;

    if (currentValue || maxValue) {
      const text = maxValue ? `${ currentValue } / ${ maxValue }` : currentValue;

      const valueWidth = 115 * zoom;
      const valueX = 51 * zoom;
      const valueY = 15 * zoom;

      this.drawText(text, valueX, valueY, valueWidth, 'center');
    }
  }

  setStampListWindow(listWindow) {
    this._listWindow = listWindow;
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  standardOutlineColor() {
    return 'rgba(0, 0, 0, 0.5)';
  }

  standardOutlineWidth() {
    return 0;
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }

}

module.exports = Window_StampContent;