const Window_Command = require('engine/windows/Window_Command');

class Window_SettingsCategoryList extends Window_Command {
  initialize(x, y, width, height) {
    this._width = width;
    this._height = height;
    super.initialize(x, y);

    this.clearCommandList();
    this.makeCommandList();
  }

  enableWindowFrame() {
    return false;
  }

  standardPadding() {
    return 0;
  }

  windowWidth() {
    return this._width;
  }

  windowHeight() {
    return this._height;
  }

  makeCommandList() {
    this.addCommand(t("General"), 'general');
    this.addCommand(t("Graphics"), 'graphics');
    this.addCommand(t("Audio"), 'audio');
    this.addCommand(t("Controls"), 'controls');
    this.addCommand(t("Extras"), 'mods');
    this.addCommand('', '-');
    this.addCommand(t("Save Changes"), 'save');
    this.addCommand(t("Discard Changes"), 'reload');

    if (!Managers.Scenes.isScene(GameScenes.Settings)) {
      this.addCommand(t("End Game"), 'endGame');
    }
  }

  select(index) {
    const refresh = this._index != index;
    super.select(index);
    if (refresh) {
      if (this._settingsListWindow) {
        this._settingsListWindow.refresh();

        this._settingsListWindow.deactivate();
        if (this._settingsListWindow.index() < 0) {
          this._settingsListWindow._index = 0;
        } else if (this._settingsListWindow.index() >= this._settingsListWindow._list.length) {
          this._settingsListWindow._index = this._settingsListWindow._list.length - 1;
        }
        this.activate();
      }
      this.refresh();
    }
  }

  drawItem(index) {
    const rect = this.itemRectForText(index);
    const symbol = this.getSymbol(index);

    if (symbol == 'save') {
      this.changeTextColor('#328ffa');
    } else if (symbol == 'reload') {
      this.changeTextColor('#fb3153');
    // } else if (symbol == 'endGame') {
    //   this.changeTextColor('#3d2b25');
    } else if (index == this.index()) {
      this.resetTextColor();
    } else {
      this.changeTextColor('#3d2b25');
    }

    this.drawText(this.commandName(index), rect.x, rect.y - 2 * Graphics.windowZoomLevel, rect.width, 'left');
  }

  lineHeight() {
    return Graphics.windowZoomLevel * 14;
  }

  spacing() {
    return 0;
  }

  verticalItemSpacing() {
    return Graphics.windowZoomLevel * 4;
  }

  setListWindow(settingsListWindow) {
    this._settingsListWindow = settingsListWindow;
    this.refresh();
  }

  standardOutlineWidth() {
    return 0;
  }

  _updateCursor() {
    if (this.active) {
      super._updateCursor();
    }
  }

  resetTextColor() {
    this.changeTextColor('#f4dea8');
  }

  isCursorVisible() {
    if (!super.isCursorVisible()) return false;
    
    const symbol = this.currentSymbol();
    if (symbol == '-') return false;

    return true;
  }

  cursorDown(wrap) {
    super.cursorDown(wrap);
    if (this.currentSymbol() == '-') {
      super.cursorDown(true);
    }
  }

  cursorUp(wrap) {
    super.cursorUp(wrap);
    if (this.currentSymbol() == '-') {
      super.cursorUp(true);
    }
  }

}

module.exports = Window_SettingsCategoryList;
