const Window_Base = require('engine/windows/Window_Base');

class Window_OverlayContent extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._zoomLevel = Graphics.windowZoomLevel;
  }

  enableWindowFrame() {
    return false;
  }

  standardFontSize() {
    return 26;
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineColor = '#f4dea8';
    this.contents.outlineWidth = 0;
  }

  lineHeight() {
    return this.standardFontSize();
  }

  refresh() {
    if (this.contents) {
      this.contents.clear();
      this.drawContent();
    }
  }

  drawIconUnderCursor(iconIndex) {
    this.drawIcon(iconIndex, TouchInput.mouseX, TouchInput.mouseY);
  }

  drawContent() {
    if (this._iconUnderCursor !== false && this._iconUnderCursor >= 0) {
      this.drawIconUnderCursor(this._iconUnderCursor);
    }
  }

  standardPadding() {
    return 0;
  }
}

module.exports = Window_OverlayContent;
