const Window_BaseDiaryContent = require('./BaseContent');

class Window_MainContent extends Window_BaseDiaryContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._profileBackgroundBitmap = Managers.Images.loadPicture('menu/profile_background_1');
    this._nextWeatherBitmap = Managers.Images.loadPicture(`menu/${ this.currentWeatherIconName() }`);
    this._emptySlotBitmap = Managers.Images.loadPicture('menu/empty_slot');
    this._staminaSlotBitmap = Managers.Images.loadPicture('menu/stamina_slot');
    this._staminaIconBitmap = Managers.Images.loadPicture('menu/stamina_icon');
    this._fatigueSlotBitmap = Managers.Images.loadPicture('menu/fatigue_slot');
    this._fatigueIconBitmap = Managers.Images.loadPicture('menu/fatigue_icon');
  }

  currentWeatherIconName() {
    switch (Managers.Weather.currentWeather) {
      case WeatherType.RAIN:
        return 'weather_rain';
      case WeatherType.SNOW:
        return 'weather_snow';
      case WeatherType.STORM:
        return 'weather_storm';
      default:
        return 'weather_sun';
    }
  }

  currentWeatherName() {
    switch (Managers.Weather.currentWeather) {
      case WeatherType.RAIN:
        return t('Raining');
      case WeatherType.SNOW:
        return t('Snowing');
      case WeatherType.STORM:
        return t('Storm');
      default:
        return t('Sunny');
    }
  }

  drawHealthLabel(originalX, originalY, label, width = null, align = 'left') {
    const x = originalX * this._zoomLevel;
    const y = originalY * this._zoomLevel;

    this.contents.fontSize =  Utils.convertFontSize(22, this._zoomLevel);
    this.drawText(label, x, y, width || this.contentsWidth(), align || 'left');
    this.resetFontSettings();
  }

  drawContent() {
    this.drawBitmap(this._profileBackgroundBitmap, 22, 11);
    this.drawBitmap(this._nextWeatherBitmap, 90, 228);

    this.drawLabel(82, 10, Managers.Player.getName());
    this.drawLabel(33, 67, Managers.Text.formatMoney(Managers.Items.gold));

    const maxStamina = Math.min(20, Math.round(Managers.Health.maxStamina / 10));
    const stamina = Managers.Health.staminaLevel / 100 * maxStamina;

    const maxFatigue = Math.min(20, Math.round(Managers.Health.maxFatigue / 10));
    const fatigue = (100 - Managers.Health.fatigueLevel) / 100 * maxFatigue;

    this.drawBitmap(this._staminaIconBitmap, 81, 27);

    let x = 99;
    
    this.changeTextColor(this.darkBaseColor());
    const staminaBuff = Managers.Health.getActiveBuffType('stamina');
    if (staminaBuff && staminaBuff.rate !== 1 && staminaBuff.time > 0) {
      let label = t("Stamina").toUpperCase() + ' ' + t("at") + ' ';
      label += Math.floor(staminaBuff.rate * 100) + '% ' + t("for") + ' ';
      label += Managers.Time.convertSecondsToTimeString(staminaBuff.time);

      this.drawHealthLabel(x, 21, label);
    } else {
      this.drawLabel(x, 21, t("Stamina"));
    }

    this.changeTextColor(this.darkBaseColor());
    const fatigueBuff = Managers.Health.getActiveBuffType('fatigue');
    if (fatigueBuff && fatigueBuff.rate !== 1 && fatigueBuff.time > 0) {
      let label = t("Fatigue").toUpperCase() + ' ' + t("at") + ' ';
      label += Math.floor(fatigueBuff.rate * 100) + '% ' + t("for") + ' ';
      label += Managers.Time.convertSecondsToTimeString(fatigueBuff.time);

      this.drawHealthLabel(x, 43, label);
    } else {
      this.drawLabel(x, 43, t("Fatigue"));
    }

    this.resetTextColor();

    for (let staminaSlotIndex = 0; staminaSlotIndex < maxStamina; staminaSlotIndex++) {
      let bitmap = stamina > staminaSlotIndex ? this._staminaSlotBitmap : this._emptySlotBitmap;
      this.drawBitmap(bitmap, x, 33);
      x += 5;
    }

    this.drawBitmap(this._fatigueIconBitmap, 81, 46);
    x = 99;
    for (let fatigueSlotIndex = 0; fatigueSlotIndex < maxFatigue; fatigueSlotIndex++) {
      let bitmap = fatigue > fatigueSlotIndex ? this._fatigueSlotBitmap : this._emptySlotBitmap;
      this.drawBitmap(bitmap, x, 55);
      x += 5;
    }

    // Main Sprite:
    const spriteName = Managers.Player.generatePlayerSpriteName();
    this.drawCharacterIcon(spriteName, 0, 34 * this._zoomLevel, 14 * this._zoomLevel, this._zoomLevel);

    // Labels:
    this.drawLabel(5, 88, t("Friends"));
    this.drawLabel(5, 152, t("Animals"));

    this.drawLabel(86, 259, this.currentWeatherName(), 46 * this._zoomLevel, 'center');
    
    const yearString = Managers.Time.getDateDescription(undefined, "Year {year}");
    this.changeTextColor(this.baseColor());
    this.contents.outlineWidth = 0;
    this.drawLabel(17, 235, yearString, 50 * this._zoomLevel, 'center');

    const monthString = t(Managers.Time.getMonthName(Managers.Time.month));
    this.changeTextColor(this.baseColor());
    this.contents.outlineWidth = 0;
    this.drawLabel(17, 225, monthString, 50 * this._zoomLevel, 'center');

    const dayString = Managers.Time.getDateDescription(undefined, "Day {day}");
    this.changeTextColor(this.baseColor());
    this.contents.outlineWidth = 0;
    this.drawLabel(155, 235, dayString, 50 * this._zoomLevel, 'center');

    const weekDay = Managers.Time.weekDay;
    const dayNameString = t(Managers.Time.getWeekDayLabel(weekDay));
    this.changeTextColor(this.baseColor());
    this.contents.outlineWidth = 0;
    this.drawLabel(155, 225, dayNameString, 50 * this._zoomLevel, 'center');
  }
}

module.exports = Window_MainContent;