const Window_DataContent = require('./DataContent');

class Window_LoadContent extends Window_DataContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
  }

  setInitialMode() {
    this._mode = 'load';
  }

  maybeChangeMode(newMode) {
  }

  updateTouchDataMode() {
    return false;
  }

  drawModes() {
    this.changeTextColor(this.baseColor());
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;
    this.contents.fontSize = Utils.convertFontSize(56, this._zoomLevel);

    this.drawLabel(17, 20, t("Load"), 216 * this._zoomLevel, 'center');
  }

  loadSlotPicutres() {
    this._selectedSlotBitmap = Managers.Images.loadPicture('menu/slot_1');
    this._regularSlotBitmap = Managers.Images.loadPicture('menu/slot_2');
  }

  loadModePictures() {
  }

  switchDataMode() {
  }

  onLoadFailure(e) {
    if (this.errorCallback) {
      this.errorCallback(e);
      return;
    }

    Managers.Sound.playBuzzer();
  }

  setErrorCallback(errorCallback) {
    this.errorCallback = errorCallback;
  }
}

module.exports = Window_LoadContent;