const Window_BaseDiaryContent = require('./BaseContent');

class Window_ItemsPage2Content extends Window_BaseDiaryContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._infoPriceABitmap = Managers.Images.loadPicture('menu/info_price_a');
    this._infoPriceBBitmap = Managers.Images.loadPicture('menu/info_price_b');
  }

  standardFontSize() {
    return Utils.convertFontSize(24, this._zoomLevel);
  }

  drawRegularPrices() {
    this.drawBitmap(this._infoPriceABitmap, 24, 248);

    const width = 48 * this._zoomLevel;
    this.drawLabel(128, 245, t('Sell Price').toUpperCase(), width, 'right');

    if (this._item && this._item.id) {
      const data = Managers.Items.getItemData(this._item.id);
      if (data && data.ingredients && data.ingredients.length > 0) {
        this.drawLabel(58, 245, t('Craft Price').toUpperCase(), width, 'right');
      } else {
        this.drawLabel(58, 245, t('Buy Price').toUpperCase(), width, 'right');
      }

      const buyPrice = Managers.Items.getBuyPrice(this._item.id);
      const sellPrice = Managers.Items.getSellPrice(this._item.id);

      this.drawLabel(58, 254, Managers.Text.formatMoney(buyPrice), width, 'right');
      this.drawLabel(128, 254, Managers.Text.formatMoney(sellPrice), width, 'right');
    } else {
      this.drawLabel(58, 245, t('Buy Price').toUpperCase(), width, 'right');
    }
  }

  drawSeedPrices(cropData) {
    this.drawBitmap(this._infoPriceBBitmap, -6, 248);
    const width = 48 * this._zoomLevel;

    this.drawLabel(92, 245, t('Sell Price').toUpperCase(), width, 'right');
    this.drawLabel(159, 245, t('Crop Value').toUpperCase(), width, 'right');

    if (this._item && this._item.id) {
      const data = Managers.Items.getItemData(this._item.id);
      if (data && data.ingredients && data.ingredients.length > 0) {
        this.drawLabel(25, 245, t('Craft Price').toUpperCase(), width, 'right');
      } else {
        this.drawLabel(25, 245, t('Buy Price').toUpperCase(), width, 'right');
      }

      const buyPrice = Managers.Items.getBuyPrice(this._item.id);
      const sellPrice = Managers.Items.getSellPrice(this._item.id);

      if (buyPrice) {
        this.drawLabel(25, 254, Managers.Text.formatMoney(buyPrice), width, 'right');
      } else {
        this.drawLabel(25, 254, '-', width, 'right');
      }

      if (sellPrice) {
        this.drawLabel(92, 254, Managers.Text.formatMoney(sellPrice), width, 'right');
      } else {
        this.drawLabel(92, 254, '-', width, 'center');
      }

      if (cropData) {
        const cropValue = Managers.Items.getSellPrice(cropData.id);
        if (cropValue) {
          this.drawLabel(159, 254, Managers.Text.formatMoney(cropValue), width, 'right');
        } else {
          this.drawLabel(159, 254, '-', width, 'center');
        }
      } else {
        this.drawLabel(159, 254, '-', width, 'center');
      }
    }
  }

  drawPrices() {
    if (this._item && this._item.id) {
      const cropData = Managers.Items.getSeedCropData(this._item.id);
      if (cropData) {
        this.drawSeedPrices(cropData);
        return;
      }
    }

    this.drawRegularPrices();
  }

  drawContent() {
    this.drawPrices();
  }

  setItem(item) {
    if (item && this._item && item.id == this._item.id) {
      return;
    }

    if (!item && !this._item) {
      return;
    }

    this._item = item;
    this.refresh();
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }
}

module.exports = Window_ItemsPage2Content;