const Window_BaseDiaryContent = require('./BaseContent');

class Window_ItemsContent extends Window_BaseDiaryContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
    this._selectedTrashBitmap = Managers.Images.loadPicture('menu/selected_trash');
    this._allowTrashSprite = false;
  }

  lockBitmap() {
    if (!this._lockBitmap) {
      this._lockBitmap = Managers.Images.loadPicture('menu/lock');
    }

    return this._lockBitmap;
  }

  drawContent() {
    let x = 0 * this._zoomLevel;
    let y = 18 * this._zoomLevel;
    let w = 100 * this._zoomLevel;
    let h = Utils.convertFontSize(56, this._zoomLevel);

    this.contents.fontSize = h;
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;

    this.changeTextColor(this.baseColor());
    this.drawText(t("Items").toUpperCase(), x, y, w, 'right');
    this.resetFontSettings();

    this.contents.fontSize = h;
    this.contents.outlineColor = this.darkBaseColor();
    this.contents.outlineWidth = 0;

    x = 115 * this._zoomLevel;
    w = 100 * this._zoomLevel;

    this.changeTextColor(this.darkBaseColor());
    this.drawText(t("Tools").toUpperCase(), x, y, w, 'left');
    this.resetFontSettings();

    if (this._allowTrashSprite && this.isMouseOverTrash()) {
      this.drawBitmap(this._selectedTrashBitmap, 89, 243);
    }

    if (!Switches.gotFirstBag) {
      this.drawBitmap(this.lockBitmap(), 100, 136);
    } else if (!Switches.gotSecondBag) {
      this.drawBitmap(this.lockBitmap(), 100, 192);
    }

    this._oldMouseX = TouchInput.mouseX;
    this._oldMouseY = TouchInput.mouseY;
    this._oldAllowTrashSprite = this._allowTrashSprite;

    this._oldIsMouseOverTrash = this.isMouseOverTrash();
  }

  isMouseOverTrash() {
    const mouseX = (TouchInput.mouseX - this.x) / Graphics.windowZoomLevel;
    const mouseY = (TouchInput.mouseY - this.y) / Graphics.windowZoomLevel;

    if (mouseX >= 89 && mouseX <= (89 + 30)) {
      if (mouseY >= 243 && mouseY <= (243 + 30)) {
        return true;
      }
    }

    return false;
  }

  isMouseOverTools() {
    const mouseX = (TouchInput.mouseX - this.x) / Graphics.windowZoomLevel;
    const mouseY = (TouchInput.mouseY - this.y) / Graphics.windowZoomLevel;

    if (mouseX >= 113 && mouseX <= (113 + 127)) {
      if (mouseY >= 19 && mouseY <= (19 + 21)) {
        return true;
      }
    }

    return false;
  }

  needsRefresh() {
    if (this._oldAllowTrashSprite != this._allowTrashSprite) {
      return true;
    }

    if (this._oldMouseX != TouchInput.mouseX || this._oldMouseY != TouchInput.mouseY) {
      if (this._oldIsMouseOverTrash != this.isMouseOverTrash()) {
        return true;
      }
    }

    return false;
  }

  refreshIfNeeded() {
    if (this.visible && this.needsRefresh()) {
      this.refresh();
    }
  }
}

module.exports = Window_ItemsContent;