const Window_BaseDiaryContent = require('./BaseContent');
// const FriendWindowHelper = require('../contexts/FriendWindowHelper');

class Window_FriendDetails extends Window_BaseDiaryContent {
  initialize(x, y, w, h) {
    this._redHeartBitmap = Managers.Images.loadPicture('menu/red_heart');
    this._halfRedHeartBitmap = Managers.Images.loadPicture('menu/half_red_heart');
    
    super.initialize(x, y, w, h);
    this.refresh();
  }

  horizontalMargin() {
    return 10 * Graphics.windowZoomLevel;
  }

  horizontalPadding() {
    return 0 * Graphics.windowZoomLevel;
  }

  verticalPadding() {
    return 0 * Graphics.windowZoomLevel;
  }

  verticalMargin() {
    return 8 * Graphics.windowZoomLevel;
  }

  standardFontSize() {
    return Utils.convertFontSize(26, Graphics.windowZoomLevel);
  }

  resetTextColor() {
    this.changeTextColor(this.blackColor());
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }

  requireBitmap(bitmap) {
    if (bitmap && !bitmap.isReady()) {
      this._needsRefresh = true;
    }
  }

  update() {
    super.update();
    if (this._needsRefresh) {
      this.refresh();
    }
  }

  refresh() {
    this._needsRefresh = false;

    this.requireBitmap(this._redHeartBitmap);
    this.requireBitmap(this._halfRedHeartBitmap);

    this._refreshExpected = this._needsRefresh;

    super.refresh();
  }

  drawContent() {
    // If the data is already outdated, don't bother drawing it
    if (this._needsRefresh) return;
    // const zoom = Graphics.windowZoomLevel;

    this.changePaintOpacity(true);
    this.resetFontSettings();

    if (!this._friendName) {
      return;
    }

    // #ToDo: Show details about the selected friend

    // let x = 10 * zoom;
    // let y = 8 * zoom;

    // const portraitBitmap = Managers.Images.loadPortrait(`default/${ this._friendName.toLowerCase() }`);
    // if (portraitBitmap) {
    //   if (portraitBitmap.isReady()) {
    //     if (portraitBitmap.height >= 50) {
    //       this._drawBitmap(portraitBitmap, x, y, zoom, true);
    //       y += (portraitBitmap.height + 10) * zoom;
    //     }
    //   } else {
    //     y += 110 * zoom;
    //     this.requireBitmap(portraitBitmap);
    //   }
    // }

    // this.contents.fontSize = Utils.convertFontSize(26, zoom);

    // const w = this.width - x - 10 * zoom;
    // this.resetFontSettings();

    // this.drawText(t("Birthday") + ':', x, y, w, 'left');
    // this.drawText('', x, y, w, 'right');

    // y += this.lineHeight();

    // const occupation = Managers.Villagers.getVillagerOccupation(this._friendName);
    // this.drawText(t("Occupation") + ':', x, y, w, 'left');
    // this.drawText(occupation, x, y, w, 'right');

    // y += this.lineHeight();
    // const location = Managers.Villagers.getVillagerLocation(this._friendName);
    // this.drawText(t("Location") + ':', x, y, w, 'left');
    // if (location) {
    //   this.drawText(location, x, y, w, 'right');
    // }

    // y += this.lineHeight() * 2;
  }

  setFriendName(friendName) {
    this._friendName = friendName;
    this.refresh();
  }

  select(index) {
    if (index != this._index) {
      super.select(index);
      super.refresh();
    }
  }
}

module.exports = Window_FriendDetails;