const Window_AnimatedBackground = require('./AnimatedBackground');

class Window_ExternalDiaryPageAnimation extends Window_AnimatedBackground {
  initialize(x, y, width, height, xOffset, yOffset, backgroundName) {
    super.initialize(x, y, width, height);
    this._xOffset = xOffset;
    this._yOffset = yOffset;

    this._imageBackground = Managers.Images.loadBackground(backgroundName);
    this._closeMenuBitmap = Managers.Images.loadPicture('menu/close_menu');
  }

  drawContent() {
    super.drawContent();

    if (this._imageBackground.isReady()) {
      const w = this._imageBackground.width;
      const h = this._imageBackground.height;

      const dW = w * Graphics.windowZoomLevel;
      const dH = h * Graphics.windowZoomLevel;

      this.contents.bltBitmap(this._imageBackground, 0, 0, w, h, this._xOffset, this._yOffset, dW, dH);
    }

    if (this._closeMenuBitmap.isReady()) {
      const buttonX = 553 * Graphics.windowZoomLevel;
      const buttonY = 49 * Graphics.windowZoomLevel;
      const buttonW = this._closeMenuBitmap.width * Graphics.windowZoomLevel;
      const buttonH = this._closeMenuBitmap.height * Graphics.windowZoomLevel;

      this.contents.bltBitmap(this._closeMenuBitmap, 0, 0, this._closeMenuBitmap.width, this._closeMenuBitmap.height, buttonX, buttonY, buttonW, buttonH);
    } else {
      this.requireBitmap(this._closeMenuBitmap);
    }
  }
}

module.exports = Window_ExternalDiaryPageAnimation;