const Window_Base = require('engine/windows/Window_Base');

class Window_DiaryToolHelp extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
    this._itemId = '';
  }

  enableWindowFrame() {
    return false;
  }

  setItem(item) {
    if (!item) {
      this._itemId = '';
      this.refresh();
      return;
    }

    if (typeof item == 'object') {
      if (item.id) {
        this._itemId = item.id;
      } else {
        this._itemId = '';
      }

      this.refresh();
      return;
    }

    this._itemId = item;
    this.refresh();
  }

  clear() {
    this.setItem('');
  }

  refresh() {
    this.contents.clear();

    if (!this._itemId) {
      return;
    }

    this.resetFontSettings();

    const itemName = Managers.Text.item(this._itemId).toUpperCase();
    const itemDescription = Managers.Text.itemDescription(this._itemId);
    const text = `<WordWrap>\\{"${ itemName }"\\}<BR>${ itemDescription }`;

    this.drawTextEx(text, this.textPadding(), 0);
  }

  textPadding() {
    return 12;
  }

  standardPadding() {
    return 0;
  }

  standardFontSize() {
    return Utils.convertFontSize(22, Graphics.windowZoomLevel);
  }

  resetTextColor() {
    this.changeTextColor(this.blackColor());
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }
}

module.exports = Window_DiaryToolHelp;