const Window_Base = require('engine/windows/Window_Base');

class Window_DiaryItemHelp extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
    this._itemId = '';
  }

  enableWindowFrame() {
    return false;
  }

  changeItemId(newItemId) {
    if (this._itemId != newItemId) {
      this._itemId = newItemId;
      this.refresh();
    }
  }

  setItem(item) {
    if (!item) {
      this.changeItemId('');
      return;
    }

    if (typeof item == 'object') {
      if (item.id) {
        this.changeItemId(item.id);
      } else {
        this.changeItemId('');
      }
      return;
    }

    this.changeItemId(item);
  }

  clear() {
    this.setItem('');
  }

  refresh() {
    this.contents.clear();

    if (!this._itemId) {
      return;
    }

    this.resetFontSettings();

    const itemName = Managers.Text.item(this._itemId).toUpperCase();
    const itemDescription = Managers.Text.itemDescription(this._itemId);
    const text = `<WordWrap>\\{"${ itemName }"\\}<BR>${ itemDescription }`;

    this.drawTextEx(text, this.textPadding(), 0);
  }

  textPadding() {
    return 12;
  }

  standardPadding() {
    return 0;
  }

  standardFontSize() {
    return Utils.convertFontSize(22, Graphics.windowZoomLevel);
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }
}

module.exports = Window_DiaryItemHelp;