const Window_Command = require('engine/windows/Window_Command');

class Window_DiaryItemCommand extends Window_Command {
  initialize(x, y, w) {
    this._windowWidth = w;
    this._item = undefined;
    super.initialize(x, y);
  }

  windowWidth() {
    return this._windowWidth;
  }

  createContents() {
    this.move(this.x, this.y, this.windowWidth(), this.windowHeight());
    super.createContents();
  }

  makeVisible(item) {
    this._item = item;
    this.refresh();

    if (this._list.length > 1) {
      this.show();
      return true;
    } else {
      return false;
    }
  }

  makeCommandList() {
    this.clearCommandList();

    if (this._item) {
      if (!TouchInput.isPressed() && !TouchInput.isReleased()) {
        this.addCommand(t('Move'), 'move');

        const itemData = Managers.Items.findItem(this._item.id);
        if (!!itemData && !!itemData.canTrash) {
          this.addCommand(t('Discard'), 'drop');
        }
      }

      // this is TOO convenient, make it an end-game ability
      // if (Managers.Items.itemIdHasPrice(this._item.id)) {
      //   this.addCommand(t('Add to Shipping Bin'), 'sell');
      // }

      if (Managers.Items.itemIdIsConsumable(this._item.id)) {
        if (this._item.type == 'medicine') {
          this.addCommand(t('Use'), 'eat');
        } else if (this._item.type == 'food') {
          if (this._item.drink) {
            this.addCommand(t('Drink'), 'eat');
          } else {
            this.addCommand(t('Eat'), 'eat');
          }
        } else {
          this.addCommand(t('Consume'), 'eat');
        }
      }

    }
    this.addCommand(t('Cancel'), 'cancel');
  }
}

module.exports = Window_DiaryItemCommand;