const Window_PopupCommand = require('../core/PopupCommand');

class Window_DataCommand extends Window_PopupCommand {
  initialize() {
    this._mode = 'save';
    super.initialize();
  }

  makeCommandList() {
    if (this._mode == 'save') {
      this.addCommand(t('Save'), 'save');
    } else if (this._mode == 'delete') {
      this.addCommand(t('Delete'), 'delete');
    } else {
      this.addCommand(t('Load'), 'load');
    }
    this.addCommand(t('Cancel'), 'cancel');
  }

  popupBackgroundName() {
    return 'popup2';
  }

  windowHeight() {
    return 80 * Graphics.windowZoomLevel;
  }

  setMode(newMode) {
    this._mode = newMode;

    this.refresh();
  }
}

module.exports = Window_DataCommand;