const Window_BaseDiaryContent = require('./BaseContent');

class Window_CalendarContent extends Window_BaseDiaryContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this.loadDayNumbers();
    this.loadPictures();
  }

  loadDayNumbers() {
    this._days = [];

    this._year = Managers.Time.year;
    this._month = Managers.Time.month;
    this._day = Managers.Time.day;

    let weekDay = Managers.Time.getDateWeekDay(this._year, this._month, 1);
    while (this._days.length < weekDay) {
      this._days.push(null);
    }

    for (let monthDay = 1; monthDay <= 31; monthDay++) {
      this._days.push(monthDay);
    }

    while (this._days.length < 42) {
      this._days.push(null);
    }

    this._holidays = Managers.Festivals.getMonthFestivalIcons(this._month);
  }

  loadPictures() {
    this._holidayBitmap = Managers.Images.loadPicture('menu/day_holiday');
    this._todayBitmap = Managers.Images.loadPicture('menu/day_today');
  }

  drawContent() {
    const zoom = this._zoomLevel;

    let x = 47 * zoom;
    let y = 20 * zoom;
    let w = 122 * zoom;
    let h = Utils.convertFontSize(56, zoom);

    this.contents.fontSize = h;
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;

    this.changeTextColor(this.baseColor());
    const monthName = t(Managers.Time.monthName);
    this.drawText(monthName.toUpperCase(), x, y, w, 'center');

    const startX = 21;
    const startY = 59;
    const dayW = 24;
    const dayH = 22;
    const dayXSeparator = 1;
    const dayYSeparator = 1;

    this.contents.fontSize = Utils.convertFontSize(28, zoom);
    this.contents.outlineWidth = 0;
    this.contents.outlineColor = this.blackColor();
    this.changeTextColor(this.blackColor());

    for (let idx = 0; idx < this._days.length; idx++) {
      const dayNum = this._days[idx];
      if (!dayNum) continue;

      const weekDay = idx % 7;
      const weekNumber = Math.floor(idx / 7);
      const dayX = startX + weekDay * (dayW + dayXSeparator);
      const dayY = startY + weekNumber * (dayH + dayYSeparator);

      const isHoliday = weekDay === 0 || this._holidays[dayNum];
      const isToday = this._day == dayNum;

      if (isHoliday) {
        // Red background is already there on sundays
        if (weekDay !== 0) {
          this.drawBitmap(this._holidayBitmap, dayX, dayY);
        }
      }
      
      if (isToday) {
        this.drawBitmap(this._todayBitmap, dayX - 1, dayY - 1);
      }

      if (isHoliday) {
        this.contents.outlineColor = this.baseColor();
        this.changeTextColor(this.baseColor());
      } else {
        this.contents.outlineColor = this.blackColor();
        this.changeTextColor(this.blackColor());
      }
      this.drawText(dayNum.toString(), (dayX + 2) * zoom, (dayY + 7) * zoom, (dayW - 4) * zoom, 'right');
    }

    this.drawNextFestival();
  }

  drawNextFestival() {
    const nextFestivalData = Managers.Festivals.getNextFestival();
    if (!nextFestivalData) {
      return;
    }

    const nextFestivalIconName = nextFestivalData.festivalId;
    const nextFestivalYearDay = nextFestivalData.yearDay;
    const nextFestivalName = t(nextFestivalData.festivalName);

    const dateData = Managers.Time.yearDayToDateObj(nextFestivalYearDay);
    const festivalMonthName = t(Managers.Time.getMonthName(dateData.month));
    const festivalDayNumber = dateData.day;

    const zoom = this._zoomLevel;
    const nextFestivalX = 52;
    const nextFestivalY = 218;
    const nextFestivalW = 93;

    this.changeTextColor(this.darkBaseColor());
    this.contents.outlineColor = this.darkBaseColor();
    this.contents.outlineWidth = 0;
    this.contents.fontSize = Utils.convertFontSize(28, zoom);
    const text = t("Next Festival");

    this.drawText(text.toUpperCase(), nextFestivalX * zoom, nextFestivalY * zoom, nextFestivalW * zoom, 'left');

    const festivalBitmap = Managers.Images.loadPicture(`menu/events/${ nextFestivalIconName }`);
    if (festivalBitmap) {
      const iconX = 10;
      const iconY = 213;

      this.drawBitmap(festivalBitmap, iconX, iconY);
    }

    this.changeTextColor(this.baseColor());
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;
    this.contents.fontSize = Utils.convertFontSize(30, zoom);

    const nameX = 60 * zoom;
    const nameY = 228 * zoom;
    const nameW = 100 * zoom;

    this.drawText(nextFestivalName.toUpperCase(), nameX, nameY, nameW, 'left');

    this.contents.fontSize = Utils.convertFontSize(80, zoom);
    const dateX = 158 * zoom;
    const dateY = 218 * zoom;
    const dateW = 50 * zoom;

    this.drawText(festivalDayNumber.toString(), dateX, dateY, dateW, 'center');

    const monthNameY = 238 * zoom;
    this.contents.fontSize = Utils.convertFontSize(30, zoom);

    this.drawText(festivalMonthName.toUpperCase(), dateX, monthNameY, dateW, 'center');
  }  
}

module.exports = Window_CalendarContent;