const Window_Selectable = require('engine/windows/Window_Selectable');

class Window_BestFriends extends Window_Selectable {
  initialize(x, y, width, height) {
    this.makeItemList();
    this._friendBackgroundBitmap = Managers.Images.loadPicture('menu/friend_layout');
    this._redHeartBitmap = Managers.Images.loadPicture('menu/red_heart');
    this._halfRedHeartBitmap = Managers.Images.loadPicture('menu/half_red_heart');

    super.initialize(x, y, width, height);
    this.refresh();
  }

  makeItemList() {
    this._friendList = Managers.Relationship.getSortedKnownVillagers(true);
  }

  enableWindowFrame() {
    return false;
  }

  drawItem(index) {
    if (index < 0) return;

    const rect = this.itemRect(index);

    const bitmap = this._friendBackgroundBitmap;
    const width = bitmap._canvas.width;
    const height = bitmap._canvas.height;
    const drawWidth = width * Graphics.windowZoomLevel;
    const drawHeight = height * Graphics.windowZoomLevel;

    const bgX = rect.x + (rect.width - (49 * Graphics.windowZoomLevel)) / 2;
    const bgY = rect.y + (21 * Graphics.windowZoomLevel);

    this.contents.bltImage(bitmap, 0, 0, width, height, bgX, bgY, drawWidth, drawHeight);

    const friendName = this._friendList[index];
    if (!friendName) return;

    const textY = (rect.y + rect.height - 6 * Graphics.windowZoomLevel) - (this.lineHeight() / 2);
    this.drawText(friendName, rect.x, textY, rect.width, 'center');

    const faceBitmap = Managers.Images.loadPortrait('mini/' + friendName.toLowerCase());
    this.requireBitmap(faceBitmap);

    if (faceBitmap.isReady()) {
      const faceWidth = faceBitmap.width;
      const faceHeight = faceBitmap.height;
      const faceX = bgX + 2 * Graphics.windowZoomLevel;
      const faceY = bgY - 10 * Graphics.windowZoomLevel;
      const faceDrawWidth = faceWidth * Graphics.windowZoomLevel;
      const faceDrawHeight = faceHeight * Graphics.windowZoomLevel;
      this.contents.bltImage(faceBitmap, 0, 0, faceWidth, faceHeight, faceX, faceY, faceDrawWidth, faceDrawHeight);
    }

    const heartsNum = Managers.Relationship.getHeartsNum(friendName);
    if (heartsNum >= 0.5) {
      let heartBitmap = heartsNum >= 1 ? this._redHeartBitmap : this._halfRedHeartBitmap;

      this.requireBitmap(this._redHeartBitmap);
      this.requireBitmap(this._halfRedHeartBitmap);

      if (this._redHeartBitmap.isReady() && this._halfRedHeartBitmap.isReady()) {
        const heartWidth = heartBitmap.width;
        const heartHeight = heartBitmap.height;
        const heartDrawWidth = heartWidth * Graphics.windowZoomLevel;
        const heartDrawHeight = heartHeight * Graphics.windowZoomLevel;

        let heartX = bgX + 35 * Graphics.windowZoomLevel;
        let heartY = bgY + 29 * Graphics.windowZoomLevel;
        this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

        if (heartsNum >= 1.5) {
          heartBitmap = heartsNum >= 2 ? this._redHeartBitmap : this._halfRedHeartBitmap;

          let heartX = bgX + 40 * Graphics.windowZoomLevel;
          let heartY = bgY + 22 * Graphics.windowZoomLevel;
          this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

          if (heartsNum >= 2.5) {
            heartBitmap = heartsNum >= 3 ? this._redHeartBitmap : this._halfRedHeartBitmap;

            let heartX = bgX + 42 * Graphics.windowZoomLevel;
            let heartY = bgY + 14 * Graphics.windowZoomLevel;
            this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

            if (heartsNum >= 3.5) {
              heartBitmap = heartsNum >= 4 ? this._redHeartBitmap : this._halfRedHeartBitmap;

              let heartX = bgX + 40 * Graphics.windowZoomLevel;
              let heartY = bgY + 6 * Graphics.windowZoomLevel;
              this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

              if (heartsNum >= 4.5) {
                heartBitmap = heartsNum >= 5 ? this._redHeartBitmap : this._halfRedHeartBitmap;

                let heartX = bgX + 35 * Graphics.windowZoomLevel;
                let heartY = bgY;
                this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);
              }
            }
          }
        }
      }
    }


  }

  drawAllItems() {
    const bitmap = this._friendBackgroundBitmap;
    this.requireBitmap(bitmap);

    if (bitmap.isReady()) {
      super.drawAllItems();
    }
  }

  horizontalMargin() {
    return 8 * Graphics.windowZoomLevel;
  }

  maxCols() {
    return 3;
  }

  horizontalPadding() {
    return 12 * Graphics.windowZoomLevel;
  }

  verticalPadding() {
    return 3 * Graphics.windowZoomLevel;
  }

  maxItems() {
    return 3;
  }

  itemHeight() {
    return this.contentsHeight();
  }

  standardFontSize() {
    return Utils.convertFontSize(26, Graphics.windowZoomLevel);
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }

  lineHeight() {
    return this.standardFontSize();
  }
}

module.exports = Window_BestFriends;