const Window_Selectable = require('engine/windows/Window_Selectable');
const AnimalWindowHelper = require('../contexts/AnimalWindowHelper');

class Window_BestAnimals extends Window_Selectable {
  initialize(x, y, width, height) {
    this.makeItemList();
    this._animalBackgroundBitmap = Managers.Images.loadPicture('menu/friend_layout');
    this._redHeartBitmap = Managers.Images.loadPicture('menu/red_heart');
    this._halfRedHeartBitmap = Managers.Images.loadPicture('menu/half_red_heart');

    super.initialize(x, y, width, height);
    this.refresh();
  }

  makeItemList() {
    this._animalList = Managers.Creatures.getAnimalList((data) => !!data._creatureName);
  }

  enableWindowFrame() {
    return false;
  }

  drawItem(index) {
    if (index < 0) return;

    const rect = this.itemRect(index);
    const zoom = Graphics.windowZoomLevel;

    const bitmap = this._animalBackgroundBitmap;
    const width = bitmap._canvas.width;
    const height = bitmap._canvas.height;
    const drawWidth = width * zoom;
    const drawHeight = height * zoom;

    const bgX = rect.x + (rect.width - (49 * zoom)) / 2;
    const bgY = rect.y + (1 * zoom);

    this.contents.bltImage(bitmap, 0, 0, width, height, bgX, bgY, drawWidth, drawHeight);

    const animalData = this._animalList[index];
    if (!animalData) return;

    const textY = (rect.y + rect.height - 6 * zoom) - (this.lineHeight() / 2);
    this.drawText(animalData._creatureName, rect.x + 5 * zoom, textY, rect.width - 10 * zoom, 'center');

    const faceBitmap = Managers.Images.loadPicture('menu/animals/' + animalData.type);
    if (faceBitmap.isReady()) {
      AnimalWindowHelper.drawAnimalFace(this, animalData, bgX, bgY, zoom, faceBitmap);
    } else {
      this.requireBitmap(faceBitmap);
    }

    const heartsNum = Managers.Relationship.friendshipToHeartNumber(animalData.friendship || 0);
    if (heartsNum >= 0.5) {
      let heartBitmap = heartsNum >= 1 ? this._redHeartBitmap : this._halfRedHeartBitmap;

      this.requireBitmap(this._redHeartBitmap);
      this.requireBitmap(this._halfRedHeartBitmap);

      if (this._redHeartBitmap.isReady() && this._halfRedHeartBitmap.isReady()) {
        const heartWidth = heartBitmap.width;
        const heartHeight = heartBitmap.height;
        const heartDrawWidth = heartWidth * zoom;
        const heartDrawHeight = heartHeight * zoom;

        let heartX = bgX + 35 * zoom;
        let heartY = bgY + 29 * zoom;
        this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

        if (heartsNum >= 1.5) {
          heartBitmap = heartsNum >= 2 ? this._redHeartBitmap : this._halfRedHeartBitmap;

          let heartX = bgX + 40 * zoom;
          let heartY = bgY + 22 * zoom;
          this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

          if (heartsNum >= 2.5) {
            heartBitmap = heartsNum >= 3 ? this._redHeartBitmap : this._halfRedHeartBitmap;

            let heartX = bgX + 42 * zoom;
            let heartY = bgY + 14 * zoom;
            this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

            if (heartsNum >= 3.5) {
              heartBitmap = heartsNum >= 4 ? this._redHeartBitmap : this._halfRedHeartBitmap;

              let heartX = bgX + 40 * zoom;
              let heartY = bgY + 6 * zoom;
              this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);

              if (heartsNum >= 4.5) {
                heartBitmap = heartsNum >= 5 ? this._redHeartBitmap : this._halfRedHeartBitmap;

                let heartX = bgX + 35 * zoom;
                let heartY = bgY;
                this.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, heartX, heartY, heartDrawWidth, heartDrawHeight);
              }
            }
          }
        }
      }
    }
  }

  drawAllItems() {
    const bitmap = this._animalBackgroundBitmap;
    this.requireBitmap(bitmap);

    if (bitmap.isReady()) {
      super.drawAllItems();
    }
  }

  horizontalMargin() {
    return 8 * Graphics.windowZoomLevel;
  }

  maxCols() {
    return 3;
  }

  horizontalPadding() {
    return 12 * Graphics.windowZoomLevel;
  }
  verticalPadding() {
    return 3 * Graphics.windowZoomLevel;
  }

  maxItems() {
    return 3;
  }

  itemHeight() {
    return this.contentsHeight();
  }

  standardFontSize() {
    return Utils.convertFontSize(26, Graphics.windowZoomLevel);
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }

  lineHeight() {
    return this.standardFontSize();
  }
}

module.exports = Window_BestAnimals;