const Window_Base = require('engine/windows/Window_Base');

class Window_BaseDiaryContent extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._zoomLevel = Graphics.windowZoomLevel;
  }

  enableWindowFrame() {
    return false;
  }

  standardFontSize() {
    return Utils.convertFontSize(26, this._zoomLevel);
  }

  resetTextColor() {
    this.changeTextColor(this.blackColor());
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;
  }

  lineHeight() {
    return this.standardFontSize();
  }

  refresh() {
    if (this.contents) {
      this.contents.clear();
      this.drawContent();
    }
  }

  drawLabel(originalX, originalY, label, width = null, align = 'left') {
    const x = originalX * this._zoomLevel;
    const y = originalY * this._zoomLevel;

    this.drawText(label.toUpperCase(), x, y, width || this.contentsWidth(), align || 'left');
    this.resetFontSettings();
  }

  drawBitmap(bitmap, originalX, originalY) {
    super.drawBitmap(bitmap, originalX, originalY, this._zoomLevel);
  }

  drawContent() {
  }

  standardPadding() {
    return 0;
  }

  drawImagePiece(fileName, x, y, sx, sy, sw, sh, zoomLevel, zoomAffectsPosition = false) {
    super.drawImagePiece(fileName, x, y, sx, sy, sw, sh, zoomLevel, zoomAffectsPosition === true);
  }

}

module.exports = Window_BaseDiaryContent;
