const Window_ItemContainer = require('../Window_ItemContainer');
const Window_Selectable = require('engine/windows/Window_Selectable');

class Window_Backpack extends Window_ItemContainer {
  initialize(x, y, width, height) {
    const slots = Managers.Items.maxItemTypes();
    this._movingItemIndex = -1;
    super.initialize(x, y, width, height, Managers.Items.container, slots);
    this._margin = 0;
    this._page2Window = null;
    this._itemSwapAction = false;
  }

  enableWindowFrame() {
    return false;
  }
  standardPadding() {
    return 0;
  }
  extraSpacing() {
    return 0;
  }
  spacing() {
    return 4 * Graphics.windowZoomLevel;
  }

  maxCols() {
    return 5;
  }

  itemWidth() {
    return Window_Selectable.prototype.itemWidth.call(this);
  }

  itemHeight() {
    return 27 * Graphics.windowZoomLevel;
  }

  drawEmptyItem(x, y, zoomLevel, index) {
  }

  drawItemBgPicture(item, x, y, zoomLevel, index) {
  }

  setPage2Window(page2Window) {
    this._page2Window = page2Window;
    this.callUpdateHelp();
  }

  setHelpWindowItem(item) {
    super.setHelpWindowItem(item);
    if (this._page2Window) {
      this._page2Window.setItem(item);
    }
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  refresh() {
    super.refresh();
    this.drawMovingItem();
  }

  drawSelectedItem() {
    const index = this.index();
    if (index < 0) return;
    if (index >= this._maxItems) return;

    const rect = this.itemRect(index);
    const item = this.getItem(index);

    const zoomLevel = Graphics.windowZoomLevel;
    const pictureName = this._movingItemIndex >= 0 || this._touchingIndex >= 0 ? 'menu/moving_slot' : 'menu/selected_slot';

    this.drawPicture(pictureName, rect.x - 1 * zoomLevel, rect.y - 1 * zoomLevel, zoomLevel, true);
    this.drawNormalItem(item, rect.x, rect.y, false, index);
  }

  drawMovingSlot(index) {
    if (index < 0) return;
    if (index == this.index()) return;

    const item = this.getItem(index);
    if (!item) return;

    const rect = this.itemRect(index);
    const zoomLevel = Graphics.windowZoomLevel;

    this.drawPicture('menu/moving_slot', rect.x - 1 * zoomLevel, rect.y - 1 * zoomLevel, zoomLevel, true);
    this.drawNormalItem(item, rect.x, rect.y, false, index);
  }

  drawMovingItem() {
    if (this._touchingIndex >= 0) {
      this.drawMovingSlot(this._touchingIndex);
    } else if (this._movingItemIndex >= 0) {
      this.drawMovingSlot(this._movingItemIndex);
    }
  }

  drawNormalItem(item, x, y, zoomedIn, index) {
    const zoomLevel = Graphics.windowZoomLevel;
    let w = 24 * zoomLevel;
    let h = 24 * zoomLevel;

    if (!!item && !!item.id) {
      this.drawItemBadge(item.iconIndex, x, y, w, h);

      const amount = this.getItemAmount(item);
      this.drawItemAmount(amount, x, y, false);
    }
  }

  swapItem(originalIndex, newIndex) {
    if (originalIndex < 0) return;
    if (originalIndex >= this._maxItems) return;

    // if (newIndex < 0) return;
    if (newIndex >= this._maxItems) return;

    // Register the item to be dropped on the next frame, this way the parent scene can intercept this action if needed.
    this._itemSwapAction = {
      originalIndex : originalIndex,
      newIndex : newIndex,
      itemData : this.getItem(originalIndex)
    };
  }

  processTouch() {
    if (this.isOpenAndVisible()) {
      if (this._touchingIndex >= 0) {
        // If the touch hasn't stopped yet
        if (TouchInput.isPressed()) {
          // And the window doesn't know of any item being moved
          if (!this._itemBeingMoved) {
            // And the index has already changed since it started
            if (this._touchingIndex != this.index()) {
              // Notify the window that an item is being moved, so that the diary can show the icon
              const item = this.getItem(this._touchingIndex);
              if (item) {
                this._itemBeingMoved = item.iconIndex;
              }
            }
          }
        } else {
          this.onTouch(false);
          // if the index changed since the touch started, move the item
          if (this._touchingIndex != this.index()) {
            // Swap the item on the old index with this one
            this.swapItem(this._touchingIndex, this.index());
          } else {
            // "click" on it if the mouse never moved
            if (!this._itemBeingMoved || this._itemBeingMoved < 0) {
              this.onTouch(true);
            }
          }

          this._itemBeingMoved = false;
          this._touchingIndex = -1;
          return;
        }
      }

      if (TouchInput.isTriggered() && this.isTouchedInsideFrame()) {
        this._touchingIndex = this.index();
        this._itemBeingMoved = false;
      } else if (TouchInput.isCancelled()) {
        if (this.isCancelEnabled()) {
          this.processCancel();
        }
      } else if (this.active || this._allowTouchWhenInactive) {
        this.onTouch(false);
      }
    } else {
      this._touchingIndex = -1;
      this._itemBeingMoved = false;
    }
  }

  onTouchOutside() {
    if (this._touchingIndex >= 0) {
      this.select(-1);
    }
  }

  update() {
    if (this._itemSwapAction) {
      const { newIndex, originalIndex } = this._itemSwapAction;
      this._itemSwapAction = false;

      if (newIndex >= 0) {
        const x = this.canvasToLocalX(TouchInput.mouseX);
        const y = this.canvasToLocalY(TouchInput.mouseY);
        if (this.isPositionInsideFrame(x, y)) {
          this._container.swapIndexes(newIndex, originalIndex);
          this.refresh();
        }
      }
    }

    super.update();
  }

  cursorPageup() {
  }

  cursorPagedown() {
  }
}

module.exports = Window_Backpack;