const Window_Base = require('engine/windows/Window_Base');

class Window_BackgroundContent extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._buttonsBgBitmap = Managers.Images.loadPicture('menu/layout_quit_button');
    this._quitBtnBitmap = Managers.Images.loadPicture('menu/quit_button');
    this._quitBtnPressedBitmap = Managers.Images.loadPicture('menu/pressed_quit_button');
    this._closeMenuBitmap = Managers.Images.loadPicture('menu/close_menu');
    
    this._mapBoxBitmap = Managers.Images.loadPicture('menu/box_map_button');
    this._mapBtnBitmap = Managers.Images.loadIcon(307);

    this._zoomLevel = Graphics.windowZoomLevel;
    this._delay = 0;
  }

  enableWindowFrame() {
    return false;
  }

  standardFontSize() {
    return Utils.convertFontSize(26, this._zoomLevel);
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineColor = '#f4dea8';
    this.contents.outlineWidth = 0;
  }

  lineHeight() {
    return this.standardFontSize();
  }

  refresh() {
    if (this.contents) {
      this.contents.clear();
      this.drawContent();
    }
  }

  drawBitmap(bitmap, originalX, originalY) {
    this.requireBitmap(bitmap);
    if (!bitmap.isReady()) return;

    const width = bitmap._canvas.width;
    const height = bitmap._canvas.height;
    const drawWidth = width * this._zoomLevel;
    const drawHeight = height * this._zoomLevel;

    const x = originalX * this._zoomLevel;
    const y = originalY * this._zoomLevel;

    this.contents.bltBitmap(bitmap, 0, 0, width, height, x, y, drawWidth, drawHeight);
  }

  drawMapButton() {
    // this.drawBitmap(this._mapBoxBitmap, 0, 0);

    // const iconZoom = this._zoomLevel / 2;
    // this.contents.bltBitmap(this._mapBtnBitmap, 0, 0, this._mapBtnBitmap.width, this._mapBtnBitmap.height, 5 * this._zoomLevel, 3, this._mapBtnBitmap.width * iconZoom, this._mapBtnBitmap.height * iconZoom);

    const textX = 22 * this._zoomLevel;
    const textY = 0 * this._zoomLevel;
    const textWidth = 100 * this._zoomLevel;

    this.contents.fontSize = Utils.convertFontSize(36, this._zoomLevel);
    this.changeTextColor('#f4dea8');
    this.contents.outlineColor = '#d7a678';
    this.contents.outlineWidth = 1;
    this.drawText(t("Map").toUpperCase(), textX, textY, textWidth, 'left');
  }

  drawDayName(x, y, z) {
    const dayName = t(Managers.Time.getDayName()).toUpperCase();

    this.contents.fontSize = Utils.convertFontSize(26, z);
    this.changeTextColor(this.redColor());
    this.contents.outlineWidth = 0;

    const textWidth = 65 * z;

    this.drawText(dayName, x * z, y * z, textWidth, 'center');
  }

  drawContent() {
    this.drawMapButton();

    this.drawDayNumber(261, 10, this._zoomLevel);
    this.drawDayName(257, 48, this._zoomLevel);

    this._oldMouseOverQuitButton = this.isMouseOverQuitButton();
    if (this._oldMouseOverQuitButton) {
      this.drawBitmap(this._buttonsBgBitmap, 535, 330);
      this.drawBitmap(this._quitBtnPressedBitmap, 580, 328);

      if (this._buttonsBgBitmap.isReady()) {
        const textX = 540 * this._zoomLevel;
        const textY = 330 * this._zoomLevel;
        const textWidth = 40 * this._zoomLevel;

        this.contents.fontSize = Utils.convertFontSize(30, this._zoomLevel);
        this.changeTextColor('#fb3153');
        this.contents.outlineColor = '#fb3153';
        this.contents.outlineWidth = 1;
        this.drawText(t("Quit").toUpperCase(), textX, textY, textWidth, 'center');
      }
    } else {
      this.drawBitmap(this._quitBtnBitmap, 580, 328);
    }

    this.drawBitmap(this._closeMenuBitmap, 523, 51);
  }

  standardPadding() {
    return 0;
  }

  update() {
    super.update();

    if (this._delay > 0) {
      this._delay--;
      return;
    }

    const isMouseOnQuit = this.isMouseOverQuitButton();
    if (isMouseOnQuit != this._oldMouseOverQuitButton) {
      this.refresh();
      this._delay = 30;
    }

    this._delay = 12;
  }

  isMouseOverQuitButton() {
    const mouseX = (TouchInput.mouseX - this.x) / this._zoomLevel;
    const mouseY = (TouchInput.mouseY - this.y) / this._zoomLevel;

    if (mouseX >= 535 && mouseX <= 640) {
      if (mouseY >= 330 && mouseY <= 360) {
        return true;
      }
    }

    return false;
  }

  isMouseOverMapButton() {
    const mouseX = (TouchInput.mouseX - this.x) / this._zoomLevel;
    const mouseY = (TouchInput.mouseY - this.y) / this._zoomLevel;

    if (mouseX > 120) return false;
    if (mouseY > 15) return false;

    return true;
  }
}

module.exports = Window_BackgroundContent;