const Window_Base = require('engine/windows/Window_Base');

class Window_AnimatedBackground extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._orangeBitmap = Managers.Images.loadPicture('menu/orange_background');
    this._zoomLevel = Graphics.windowZoomLevel;
    this._initialX = 0;
    this._initialY = 0;

    this._refreshDelay = 1;
  }

  enableWindowFrame() {
    return false;
  }

  refresh() {
    if (this.contents) {
      this.contents.clear();
      this.drawContent();
    }
  }

  update() {
    super.update();

    if (this._refreshDelay > 0) {
      this._refreshDelay--;
      return;
    }

    this._refreshDelay = 1;
    this.refresh();
  }

  drawContent() {
    const bitmap = this._orangeBitmap;
    this.requireBitmap(bitmap);

    if (!bitmap.isReady()) {
      return;
    }

    this.updatePosition(bitmap);
    this.drawAnimation(bitmap);
  }

  drawAnimation(bitmap) {
    if (!bitmap._image) return;

    this.contents._context.globalCompositeOperation = 'source-over';
    this.contents._context.imageSmoothingEnabled = false;

    const width = bitmap.width;
    const height = bitmap.height;
    const drawWidth = width * this._zoomLevel;
    const drawHeight = height * this._zoomLevel;

    for (let x = this._initialX; x < Graphics.width; x += drawWidth) {
      for (let y = this._initialY; y < Graphics.height; y += drawHeight) {

        this.contents._context.drawImage(bitmap._image, 0, 0, width, height, x, y, drawWidth, drawHeight);
      }
    }

    this.contents._setDirty();
  }

  updatePosition(bitmap) {
    const xSpeed = 1;
    const ySpeed = 1;

    this._initialX += xSpeed;
    this._initialY -= ySpeed;

    if (this._initialX > 0 || this._initialY < (0 - bitmap.height * this._zoomLevel)) {
      this._initialX = 0 - (bitmap.width * this._zoomLevel);
      this._initialY = 0;
    }
  }

  standardPadding() {
    return 0;
  }

  standardOutlineWidth() {
    return 0;
  }
}

module.exports = Window_AnimatedBackground;