const Window_BaseDiaryContent = require('./BaseContent');

class Window_AnimalsContent extends Window_BaseDiaryContent {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);

    this._rightTitle = Managers.Images.loadPicture('menu/right_title');
  }

  drawContent() {
    let x = 35 * this._zoomLevel;
    let y = 55 * this._zoomLevel;
    let w = 110 * this._zoomLevel;
    let h = Utils.convertFontSize(56, this._zoomLevel);

    this.drawBitmap(this._rightTitle, 160, 53);

    this.contents.fontSize = h;
    this.contents.outlineColor = this.darkBaseColor();
    this.contents.outlineWidth = 0;

    this.changeTextColor(this.darkBaseColor());
    this.drawText(t("Friends").toUpperCase(), x, y, w, 'right');
    this.resetFontSettings();

    this.contents.fontSize = h;
    this.contents.outlineColor = this.baseColor();
    this.contents.outlineWidth = 0;

    x = 164 * this._zoomLevel;
    w = 100 * this._zoomLevel;

    this.changeTextColor(this.baseColor());
    this.drawText(t("Animals").toUpperCase(), x, y, w, 'left');
    this.resetFontSettings();

    this._oldMouseX = TouchInput.mouseX;
    this._oldMouseY = TouchInput.mouseY;
  }

  isMouseOverFriends() {
    const mouseX = (TouchInput.mouseX - this.x) / Graphics.windowZoomLevel;
    const mouseY = (TouchInput.mouseY - this.y) / Graphics.windowZoomLevel;

    if (mouseX >= 35 && mouseX <= (35 + 120)) {
      if (mouseY >= 55 && mouseY <= (55 + 21)) {
        return true;
      }
    }

    return false;
  }
}

module.exports = Window_AnimalsContent;