const Window_BaseDiaryContent = require('./BaseContent');
const AnimalWindowHelper = require('../contexts/AnimalWindowHelper');

class Window_AnimalDetails extends Window_BaseDiaryContent {
  initialize(x, y, w, h) {
    this._redHeartBitmap = Managers.Images.loadPicture('menu/red_heart');
    this._halfRedHeartBitmap = Managers.Images.loadPicture('menu/half_red_heart');
    
    super.initialize(x, y, w, h);
    this.refresh();
  }

  horizontalMargin() {
    return 10 * Graphics.windowZoomLevel;
  }

  horizontalPadding() {
    return 0 * Graphics.windowZoomLevel;
  }

  verticalPadding() {
    return 0 * Graphics.windowZoomLevel;
  }

  verticalMargin() {
    return 8 * Graphics.windowZoomLevel;
  }

  standardFontSize() {
    return Utils.convertFontSize(26, Graphics.windowZoomLevel);
  }

  resetTextColor() {
    this.changeTextColor(this.blackColor());
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }

  requireBitmap(bitmap) {
    if (bitmap && !bitmap.isReady()) {
      this._needsRefresh = true;
    }
  }

  update() {
    super.update();
    if (this._needsRefresh) {
      this.refresh();
    }
  }

  refresh() {
    this._needsRefresh = false;

    this.requireBitmap(this._redHeartBitmap);
    this.requireBitmap(this._halfRedHeartBitmap);

    this._refreshExpected = this._needsRefresh;

    super.refresh();
  }

  drawContent() {
    // If the data is already outdated, don't bother drawing it
    if (this._needsRefresh) return;
    const zoom = Graphics.windowZoomLevel;

    this.changePaintOpacity(true);
    this.resetFontSettings();

    if (!this._animalData) {
      return;
    }

    let x = 10 * zoom;
    let y = 8 * zoom;

    this.contents.fontSize = Utils.convertFontSize(26, zoom);
    AnimalWindowHelper.drawAnimalBadgeAt(this, x, y, this._animalData, zoom, true);

    x += 65 * zoom;
    const w = this.width - x - 10 * zoom;
    this.resetFontSettings();

    const typeName = Managers.Text.creature(this._animalData._type);
    this.drawText(t("Type") + ':', x, y, w, 'left');
    this.drawText(typeName, x, y, w, 'right');

    y += this.lineHeight();
    if (this._animalData.age) {
      const ageString = Managers.Time.getFormattedAge(this._animalData.age);
      this.drawText(t("Age") + ':', x, y, w, 'left');
      this.drawText(ageString, x, y, w, 'right');
    }

    y += this.lineHeight();
    const location = Managers.Map.getMapDisplayName(this._animalData.mapId);
    this.drawText(t("Location") + ':', x, y, w, 'left');
    this.drawText(location, x, y, w, 'right');

    y += this.lineHeight() * 2;
    if (this._animalData.type.match(/chick/)) {
      this.drawChickenData(y);
    }
  }

  drawChickenData(y) {
    const zoom = Graphics.windowZoomLevel;
    const x = 10 * zoom;
    const w = this.width - x * 2;

    this.contents.fontSize = Utils.convertFontSize(32, zoom);
    this.drawText(t("Attributes") + ':', x, y, w, 'left');

    this.resetFontSettings();
    y += this.lineHeight();

    this.drawText(t("Speed Score") + ':', x, y, w, 'left');
    const speed = Math.round(this._animalData._chickenSpeed * 20);
    this.drawText(speed, x, y, w, 'right');

    y += this.lineHeight();
    this.drawText(t("Egg Chance") + ':', x, y, w, 'left');
    const eggChance = 100 + Math.round(this._animalData._chickenEggChance * 20);
    this.drawText(eggChance + '%', x, y, w, 'right');

    y += this.lineHeight();
    this.drawText(t("Luck Score") + ':', x, y, w, 'left');
    const luck = Math.round(this._animalData._chickenLuck * 20);
    this.drawText(luck, x, y, w, 'right');
  }

  setAnimalData(animalData) {
    this._animalData = animalData;
    this.refresh();
  }

  select(index) {
    if (index != this._index) {
      super.select(index);
      super.refresh();
    }
  }
}

module.exports = Window_AnimalDetails;