const Window_AnimatedBackground = require('../diary/AnimatedBackground');

class Window_CookingBackground extends Window_AnimatedBackground {
  initialize(x, y, width, height, xOffset, yOffset) {
    super.initialize(x, y, width, height);
    this._zoomLevel = Graphics.windowZoomLevel;

    this._xOffset = xOffset;
    this._yOffset = yOffset;

    this._imageBackground = Managers.Images.loadBackground('cooking_layout');
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  drawBitmap(bitmap, originalX, originalY) {
    this.requireBitmap(bitmap);
    if (!bitmap.isReady()) return;

    const width = bitmap._canvas.width;
    const height = bitmap._canvas.height;
    const drawWidth = width * this._zoomLevel;
    const drawHeight = height * this._zoomLevel;

    const x = originalX * this._zoomLevel;
    const y = originalY * this._zoomLevel;

    this.contents.bltBitmap(bitmap, 0, 0, width, height, x, y, drawWidth, drawHeight);
  }

  drawContent() {
    super.drawContent();

    if (this._imageBackground.isReady()) {
      const w = this._imageBackground.width;
      const h = this._imageBackground.height;

      const dW = w * Graphics.windowZoomLevel;
      const dH = h * Graphics.windowZoomLevel;

      this.contents.bltImage(this._imageBackground, 0, 0, w, h, this._xOffset, this._yOffset, dW, dH);
    }
  }

  update() {
    super.update();
  }
}

module.exports = Window_CookingBackground;