const Window_ItemContainer = require('../Window_ItemContainer');
const Window_Selectable = require('engine/windows/Window_Selectable');

class Window_BackpackCookingItems extends Window_ItemContainer {
  initialize(x, y, width, height) {
    const slots = Managers.Items.maxItemTypes();
    super.initialize(x, y, width, height, Managers.Items.container, slots);
    this._margin = 0;
    this._allowTouchWhenInactive = true;
  }

  enableWindowFrame() {
    return false;
  }

  standardPadding() {
    return 0;
  }

  extraSpacing() {
    return 0;
  }

  horizontalMargin() {
    return 53 * Graphics.windowZoomLevel;
  }

  verticalMargin() {
    return 29 * Graphics.windowZoomLevel;
  }

  spacing() {
    return 4 * Graphics.windowZoomLevel;
  }

  maxCols() {
    return 10;
  }

  rows() {
    return Math.ceil(this._maxItems / this.maxCols());
  }

  itemWidth() {
    return Window_Selectable.prototype.itemWidth.call(this);
  }

  itemHeight() {
    return 27 * Graphics.windowZoomLevel;
  }

  drawEmptyItem(x, y, zoomLevel, index) {
  }

  drawItemBgPicture(item, x, y, zoomLevel, index) {
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  refresh() {
    super.refresh();
  }

  drawSelectedItem() {
    const index = this.index();
    if (index < 0) return;
    if (index >= this._maxItems) return;

    const rect = this.itemRect(index);
    const item = this.getItem(index);

    this.drawNormalItem(item, rect.x, rect.y, false, index);
  }

  drawNormalItem(item, x, y, zoomedIn, index) {
    const zoomLevel = Graphics.windowZoomLevel;
    let w = 24 * zoomLevel;
    let h = 24 * zoomLevel;

    if (index === this.index()) {
      this.drawPicture('menu/selected_slot', x - 1 * zoomLevel, y - 1 * zoomLevel, zoomLevel, true);
    } else {
      this.contents.fillRect(x, y, w, h, this.darkBaseColor());
    }

    if (item && item.id) {
      this.changePaintOpacity(item.canCook);
      this.drawItemBadge(item.iconIndex, x, y, w, h);

      const amount = this.getItemAmount(item);
      this.drawItemAmount(amount, x, y, false);
      this.changePaintOpacity(true);
    }
  }

  drawItem(index) {
    if (index == this.index()) return;

    const row = Math.floor(index / this.maxCols());
    if (row < this.topRow()) return;

    const item = this.getItem(index);
    const rect = this.itemRect(index);
    rect.width -= this.textPadding();

    const maxHeight = this.contentsHeight();
    if (rect.y + rect.height >= maxHeight) return;

    this.drawNormalItem(item, rect.x, rect.y, false, index);
  }

  processTouch() {
    if (this.isOpenAndVisible()) {
      if (TouchInput.isTriggered() && this.isTouchedInsideFrame()) {
        this.onTouch(true);
      } else if (TouchInput.isCancelled()) {
        if (this.isCancelEnabled()) {
          this.processCancel();
        }
      } else if (this.active || this._allowTouchWhenInactive) {
        this.onTouch(false);
      }
    }
  }

  cursorPageup() {
  }

  cursorPagedown() {
  }

  drawPicture(filename, x, y, zoomLevel) {
    super.drawPicture(filename, x, y, zoomLevel, true);
  }
}

module.exports = Window_BackpackCookingItems;