const Window_Base = require('engine/windows/Window_Base');

class Window_Warning extends Window_Base {
  initialize() {
    const width = 166 * Graphics.windowZoomLevel;
    const height = 80 * Graphics.windowZoomLevel;
    const x = (Graphics.width - width) / 2;
    const y = (Graphics.height - height) / 2;

    super.initialize(x, y, width, height);

    this._bgBitmap = Managers.Images.loadBackground('popup');
  }

  setText(text) {
    this._text = `<WordWrap>${ text }`;
    this.refresh();
  }

  clear() {
    this.setText('');
  }

  refresh() {
    this.contents.clear();

    if (!this._bgBitmap) return;
    this.drawBitmap(this._bgBitmap, 0, 0, Graphics.windowZoomLevel);
    
    const x = this.textPadding();
    const y = 17 * Graphics.windowZoomLevel;
    this.drawTextEx(this._text, x, y);
  }

  textPadding() {
    return 12 * Graphics.windowZoomLevel;
  }

  textMargin() {
    return 12 * Graphics.windowZoomLevel;
  }

  standardPadding() {
    return 0;
  }

  standardFontSize() {
    return Utils.convertFontSize(26, Graphics.windowZoomLevel);
  }

  enableWindowFrame() {
    return false;
  }

  standardOutlineWidth() {
    return 0;
  }

  normalColor() {
    return this.blackColor();
  }
}

module.exports = Window_Warning;
