const Window_Command = require('engine/windows/Window_Command');

class Window_PopupCommand extends Window_Command {
  initialize() {
    super.initialize(0, 0);

    this._bgBitmap = Managers.Images.loadBackground(this.popupBackgroundName());
  }

  popupBackgroundName() {
    return 'popup';
  }

  windowWidth() {
    return 166 * Graphics.windowZoomLevel;
  }

  windowHeight() {
    return 90 * Graphics.windowZoomLevel;
  }

  createContents() {
    const x = (Graphics.width - this.windowWidth()) / 2;
    const y = (Graphics.height - this.windowHeight()) / 2;

    this.move(x, y, this.windowWidth(), this.windowHeight());
    super.createContents();
  }

  makeCommandList() {
  }

  show() {
    $gameTemp.skipSelectableWindowHandling();
    this._index = -1;
    super.show();
  }

  maxCols() {
    return 1;
  }

  drawAllItems() {
    if (!this._bgBitmap) return;

    this.drawBitmap(this._bgBitmap, 0, 0, Graphics.windowZoomLevel);
    super.drawAllItems();
  }

  enableWindowFrame() {
    return false;
  }

  standardPadding() {
    return 0;
  }

  spacing() {
    return 7;
  }

  verticalMargin() {
    return 24 * Graphics.windowZoomLevel;
  }

  itemRect(index) {
    const rect = new Rectangle();
    const maxCols = this.maxCols();
    const vSpacing = this.verticalItemSpacing();

    rect.width = this.itemWidth();
    rect.height = this.itemHeight();
    rect.x = (23 * Graphics.windowZoomLevel) + index % maxCols * (rect.width + this.spacing()) - this._scrollX + this.horizontalMargin();
    rect.y = Math.floor(index / maxCols) * (rect.height + vSpacing) - this._scrollY + this.verticalMargin();
    return rect;
  }

  drawItem(index) {
    if (index == this._index) {
      const fullRect = this.itemRect(index);
      this.contents.fillRect(fullRect.x, fullRect.y, fullRect.width, fullRect.height, '#d7a678');
    }

    const rect = this.itemRectForText(index);
    const align = this.itemTextAlign();
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
  }

  itemWidth() {
    return 117 * Graphics.windowZoomLevel;
  }

  itemTextAlign() {
    return 'center';
  }

  select(index) {
    super.select(index);
    this.refresh();
  }

  normalColor() {
    return this.blackColor();
  }

  standardOutlineWidth() {
    return 0;
  }
}

module.exports = Window_PopupCommand;