const AnimalWindowHelper = require('./AnimalWindowHelper');

class FriendWindowHelper {
  static requestPortraitList(friendList) {
    for (const friend of friendList) {
      if (!friend) continue;

      Managers.Images.loadPortrait('mini/' + friend.toLowerCase());
    }
  }

  static drawFriendBadge(windowInstance, rect, friendName, zoom, useDarkLayout, useSelectedLayout) {
    const layoutName = `menu/friend_layout${ useSelectedLayout ? '_selected' : '' }${ useDarkLayout ? '_dark' : '' }`;

    const bitmap = Managers.Images.loadPicture(layoutName);
    const width = bitmap._canvas.width;
    const height = bitmap._canvas.height;
    const drawWidth = width * zoom;
    const drawHeight = height * zoom;
    const margin = 3 * zoom;

    const bgX = rect.x + (rect.width - (49 * zoom)) / 2;
    const bgY = rect.y + (17 * zoom) - margin;

    windowInstance.contents.bltImage(bitmap, 0, 0, width, height, bgX, bgY, drawWidth, drawHeight);

    if (!friendName) return;

    const faceBitmap = Managers.Images.loadPortrait('mini/' + friendName.toLowerCase());
    windowInstance.requireBitmap(faceBitmap);

    if (windowInstance._needsRefresh) {
      return;
    }

    const displayName = Managers.Relationship.isCharacterKnown(friendName) ? friendName : '?';

    const textY = (rect.y + rect.height - 6 * zoom) - (windowInstance.lineHeight() / 2) - margin;
    windowInstance.drawText(displayName, rect.x + 5 * zoom, textY, rect.width - 10 * zoom, 'center');

    if (faceBitmap.isReady()) {
      const faceWidth = faceBitmap.width;
      const faceHeight = faceBitmap.height;
      const faceX = bgX + 2 * Graphics.windowZoomLevel;
      const faceY = bgY - 10 * Graphics.windowZoomLevel;
      const faceDrawWidth = faceWidth * Graphics.windowZoomLevel;
      const faceDrawHeight = faceHeight * Graphics.windowZoomLevel;
      windowInstance.contents.bltImage(faceBitmap, 0, 0, faceWidth, faceHeight, faceX, faceY, faceDrawWidth, faceDrawHeight);
    }

    const heartsNum = Managers.Relationship.getHeartsNum(friendName) || 0;
    AnimalWindowHelper.drawAnimalBadgeHearts(windowInstance, heartsNum, bgX, bgY, zoom, useDarkLayout);
  }

  static drawFriendBadgeAt(windowInstance, x, y, friendName, zoom) {
    const rect = new Rectangle(x, y, 58 * zoom, 46 * zoom);
    this.drawFriendBadge(windowInstance, rect, friendName, zoom);
  }
}

module.exports = FriendWindowHelper;