class AnimalWindowHelper {
  static drawAnimalBadgeHearts(windowInstance, heartsNum, x, y, zoom, useDarkLayout) {
    if (heartsNum < 0.5) return;

    const redHeartBitmap = Managers.Images.loadPicture(useDarkLayout ? 'menu/red_heart_dark' : 'menu/red_heart');
    const halfRedHeartBitmap = Managers.Images.loadPicture(useDarkLayout ? 'menu/half_red_heart_dark' : 'menu/half_red_heart');

    let heartBitmap = heartsNum >= 1 ? redHeartBitmap : halfRedHeartBitmap;

    windowInstance.requireBitmap(redHeartBitmap);
    windowInstance.requireBitmap(halfRedHeartBitmap);

    if (!redHeartBitmap.isReady() || !halfRedHeartBitmap.isReady()) {
      return;
    }

    const heartWidth = heartBitmap.width;
    const heartHeight = heartBitmap.height;
    const heartDrawWidth = heartWidth * zoom;
    const heartDrawHeight = heartHeight * zoom;

    windowInstance.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, x + 35 * zoom, y + 29 * zoom, heartDrawWidth, heartDrawHeight);

    if (heartsNum < 1.5) return;

    heartBitmap = heartsNum >= 2 ? redHeartBitmap : halfRedHeartBitmap;
    windowInstance.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, x + 40 * zoom, y + 22 * zoom, heartDrawWidth, heartDrawHeight);

    if (heartsNum < 2.5) return;

    heartBitmap = heartsNum >= 3 ? redHeartBitmap : halfRedHeartBitmap;
    windowInstance.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, x + 42 * zoom, y + 14 * zoom, heartDrawWidth, heartDrawHeight);

    if (heartsNum < 3.5) return;

    heartBitmap = heartsNum >= 4 ? redHeartBitmap : halfRedHeartBitmap;
    windowInstance.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, x + 40 * zoom, y + 6 * zoom, heartDrawWidth, heartDrawHeight);

    if (heartsNum < 4.5) return;

    heartBitmap = heartsNum >= 5 ? redHeartBitmap : halfRedHeartBitmap;
    windowInstance.contents.bltImage(heartBitmap, 0, 0, heartWidth, heartHeight, x + 35 * zoom, y, heartDrawWidth, heartDrawHeight);
  }

  static drawAnimalTypeFace(windowInstance, type, x, y, zoom, faceBitmap) {
    if (!faceBitmap) {
      faceBitmap = Managers.Images.loadPicture('menu/animals/' + type);
      windowInstance.requireBitmap(faceBitmap);
    }

    if (faceBitmap.isReady()) {
      const faceWidth = faceBitmap.width;
      const faceHeight = faceBitmap.height;
      const faceDrawWidth = faceWidth * zoom;
      const faceDrawHeight = faceHeight * zoom;

      let faceX = x + 2 * zoom;
      let faceY = y - 4 * zoom;

      // Old sizes
      if (faceWidth === 32 && faceHeight === 32) {
        faceX = x + 7 * zoom;
        faceY = y + 1 * zoom;
      }

      windowInstance.contents.bltImage(faceBitmap, 0, 0, faceWidth, faceHeight, faceX, faceY, faceDrawWidth, faceDrawHeight);
      return true;
    }

    return false;
  }

  static drawAnimalFace(windowInstance, animalData, x, y, zoom, faceBitmap) {
    return this.drawAnimalTypeFace(windowInstance, animalData.type, x, y, zoom, faceBitmap);
  }

  static drawAnimalBadge(windowInstance, rect, animalData, zoom, useDarkLayout, useSelectedLayout, nameMargin = 0) {
    const layoutName = `menu/friend_layout${ useSelectedLayout ? '_selected' : '' }${ useDarkLayout ? '_dark' : '' }`;
    const bitmap = Managers.Images.loadPicture(layoutName);
    const width = bitmap._canvas.width;
    const height = bitmap._canvas.height;
    const drawWidth = width * zoom;
    const drawHeight = height * zoom;

    const bgX = rect.x + (rect.width - (49 * zoom)) / 2;
    const bgY = rect.y + (1 * zoom);

    windowInstance.contents.bltImage(bitmap, 0, 0, width, height, bgX, bgY, drawWidth, drawHeight);

    if (!animalData) return;

    const textY = (rect.y + rect.height - 6 * zoom) - (windowInstance.lineHeight() / 2) + nameMargin;
    windowInstance.drawText(animalData._creatureName, rect.x + 5 * zoom, textY, rect.width - 10 * zoom, 'center');

    this.drawAnimalFace(windowInstance, animalData, bgX, bgY, zoom);

    const heartsNum = Managers.Relationship.friendshipToHeartNumber(animalData.friendship || 0);
    this.drawAnimalBadgeHearts(windowInstance, heartsNum, bgX, bgY, zoom, useDarkLayout);
  }

  static drawAnimalBadgeAt(windowInstance, x, y, animalData, zoom, useDarkLayout, useSelectedLayout) {
    const rect = new Rectangle(x, y, 58 * zoom, 46 * zoom);
    this.drawAnimalBadge(windowInstance, rect, animalData, zoom, useDarkLayout, useSelectedLayout);
  }
}

module.exports = AnimalWindowHelper;